/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.RLSDeviceType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class RLSDevice
implements XDRType,
SYMbolAPIConstants {
    private RLSDeviceType type = new RLSDeviceType();
    private ControllerRef controller = new ControllerRef();
    private DriveRef drive = new DriveRef();
    private ComponentRef esm = new ComponentRef();

    public RLSDevice() {
    }

    public RLSDevice(RLSDevice rLSDevice) {
        this.controller = rLSDevice.controller;
        this.drive = rLSDevice.drive;
        this.esm = rLSDevice.esm;
    }

    public ControllerRef getController() {
        return this.controller;
    }

    public DriveRef getDrive() {
        return this.drive;
    }

    public ComponentRef getEsm() {
        return this.esm;
    }

    public RLSDeviceType getType() {
        return this.type;
    }

    public void setController(ControllerRef controllerRef) {
        this.controller = controllerRef;
    }

    public void setDrive(DriveRef driveRef) {
        this.drive = driveRef;
    }

    public void setEsm(ComponentRef componentRef) {
        this.esm = componentRef;
    }

    public void setType(RLSDeviceType rLSDeviceType) {
        this.type = rLSDeviceType;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        this.type.xdrDecode(xDRInputStream);
        switch (this.type.getValue()) {
            case 1: {
                this.controller.xdrDecode(xDRInputStream);
                break;
            }
            case 2: {
                this.drive.xdrDecode(xDRInputStream);
                break;
            }
            case 3: {
                this.esm.xdrDecode(xDRInputStream);
                break;
            }
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.type.xdrEncode(xDROutputStream);
        switch (this.type.getValue()) {
            case 1: {
                this.controller.xdrEncode(xDROutputStream);
                break;
            }
            case 2: {
                this.drive.xdrEncode(xDROutputStream);
                break;
            }
            case 3: {
                this.esm.xdrEncode(xDROutputStream);
                break;
            }
        }
        xDROutputStream.setLength(n);
    }
}

