/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ParityStatus;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class ParityScanResponse
implements XDRType,
SYMbolAPIConstants {
    private ReturnCode returnCode = new ReturnCode();
    private ParityStatus parityStatus = new ParityStatus();
    private long endingLBA;

    public ParityScanResponse() {
    }

    public ParityScanResponse(ParityScanResponse parityScanResponse) {
        this.returnCode = parityScanResponse.returnCode;
        this.parityStatus = parityScanResponse.parityStatus;
        this.endingLBA = parityScanResponse.endingLBA;
    }

    public long getEndingLBA() {
        return this.endingLBA;
    }

    public ParityStatus getParityStatus() {
        return this.parityStatus;
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public void setEndingLBA(long l) {
        this.endingLBA = l;
    }

    public void setParityStatus(ParityStatus parityStatus) {
        this.parityStatus = parityStatus;
    }

    public void setReturnCode(ReturnCode returnCode) {
        this.returnCode = returnCode;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.returnCode.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.parityStatus.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.endingLBA = xDRInputStream.getLong();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.returnCode.xdrEncode(xDROutputStream);
        this.parityStatus.xdrEncode(xDROutputStream);
        xDROutputStream.putLong(this.endingLBA);
        xDROutputStream.setLength(n);
    }
}

