/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class InterfaceUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef controllerRef = new ControllerRef();
    private int preferredID;
    private byte[] portName;

    public InterfaceUpdateDescriptor() {
    }

    public InterfaceUpdateDescriptor(InterfaceUpdateDescriptor interfaceUpdateDescriptor) {
        this.controllerRef = interfaceUpdateDescriptor.controllerRef;
        this.preferredID = interfaceUpdateDescriptor.preferredID;
        this.portName = interfaceUpdateDescriptor.portName;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public byte[] getPortName() {
        return this.portName;
    }

    public int getPreferredID() {
        return this.preferredID;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public void setPortName(byte[] byArray) {
        this.portName = byArray;
    }

    public void setPreferredID(int n) {
        this.preferredID = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.preferredID = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.portName = xDRInputStream.getFixedOpaque(8);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.controllerRef.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.preferredID);
        xDROutputStream.putFixedOpaque(this.portName, 8);
        xDROutputStream.setLength(n);
    }
}

