/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.GBICParentTypeData;
import devmgr.versioned.symbol.GBICPort;
import devmgr.versioned.symbol.GBICStatus;
import devmgr.versioned.symbol.GBICType;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class Gbic
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef gbicRef = new ComponentRef();
    private GBICStatus status = new GBICStatus();
    private Location physicalLocation = new Location();
    private GBICType gbicType = new GBICType();
    private GBICPort gbicPort = new GBICPort();
    private GBICParentTypeData parentData = new GBICParentTypeData();
    private byte[] reserved1;
    private byte[] reserved2;

    public Gbic() {
    }

    public Gbic(Gbic gbic) {
        this.gbicRef = gbic.gbicRef;
        this.status = gbic.status;
        this.physicalLocation = gbic.physicalLocation;
        this.gbicType = gbic.gbicType;
        this.gbicPort = gbic.gbicPort;
        this.parentData = gbic.parentData;
        this.reserved1 = gbic.reserved1;
        this.reserved2 = gbic.reserved2;
    }

    public GBICPort getGbicPort() {
        return this.gbicPort;
    }

    public ComponentRef getGbicRef() {
        return this.gbicRef;
    }

    public GBICType getGbicType() {
        return this.gbicType;
    }

    public GBICParentTypeData getParentData() {
        return this.parentData;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public GBICStatus getStatus() {
        return this.status;
    }

    public void setGbicPort(GBICPort gBICPort) {
        this.gbicPort = gBICPort;
    }

    public void setGbicRef(ComponentRef componentRef) {
        this.gbicRef = componentRef;
    }

    public void setGbicType(GBICType gBICType) {
        this.gbicType = gBICType;
    }

    public void setParentData(GBICParentTypeData gBICParentTypeData) {
        this.parentData = gBICParentTypeData;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setStatus(GBICStatus gBICStatus) {
        this.status = gBICStatus;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.gbicRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.gbicType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.gbicPort.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.parentData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.gbicRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        this.gbicType.xdrEncode(xDROutputStream);
        this.gbicPort.xdrEncode(xDROutputStream);
        this.parentData.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

