/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Capability;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class FeatureKey
implements XDRType,
SYMbolAPIConstants {
    private int keyVersion;
    private Capability capability = new Capability();
    private SAIdentifier saId = new SAIdentifier();
    private byte[] digest;

    public FeatureKey() {
    }

    public FeatureKey(FeatureKey featureKey) {
        this.keyVersion = featureKey.keyVersion;
        this.capability = featureKey.capability;
        this.saId = featureKey.saId;
        this.digest = featureKey.digest;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public SAIdentifier getSaId() {
        return this.saId;
    }

    public void setCapability(Capability capability) {
        this.capability = capability;
    }

    public void setDigest(byte[] byArray) {
        this.digest = byArray;
    }

    public void setKeyVersion(int n) {
        this.keyVersion = n;
    }

    public void setSaId(SAIdentifier sAIdentifier) {
        this.saId = sAIdentifier;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.keyVersion = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.capability.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.saId.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.digest = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.keyVersion);
        this.capability.xdrEncode(xDROutputStream);
        this.saId.xdrEncode(xDROutputStream);
        xDROutputStream.putVariableOpaque(this.digest);
        xDROutputStream.setLength(n);
    }
}

