/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.FanStatus;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class Fan
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef fanRef = new ComponentRef();
    private FanStatus status = new FanStatus();
    private Location physicalLocation = new Location();
    private byte[] reserved1;
    private byte[] reserved2;

    public Fan() {
    }

    public Fan(Fan fan) {
        this.fanRef = fan.fanRef;
        this.status = fan.status;
        this.physicalLocation = fan.physicalLocation;
        this.reserved1 = fan.reserved1;
        this.reserved2 = fan.reserved2;
    }

    public ComponentRef getFanRef() {
        return this.fanRef;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public FanStatus getStatus() {
        return this.status;
    }

    public void setFanRef(ComponentRef componentRef) {
        this.fanRef = componentRef;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setStatus(FanStatus fanStatus) {
        this.status = fanStatus;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.fanRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.fanRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

