/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class DriveLogData
implements XDRType,
SYMbolAPIConstants {
    private ReturnCode returnCode = new ReturnCode();
    private String serialNumber;
    private Location physicalLocation = new Location();
    private byte[] logs;

    public DriveLogData() {
    }

    public DriveLogData(DriveLogData driveLogData) {
        this.returnCode = driveLogData.returnCode;
        this.serialNumber = driveLogData.serialNumber;
        this.physicalLocation = driveLogData.physicalLocation;
        this.logs = driveLogData.logs;
    }

    public byte[] getLogs() {
        return this.logs;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setLogs(byte[] byArray) {
        this.logs = byArray;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setReturnCode(ReturnCode returnCode) {
        this.returnCode = returnCode;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.returnCode.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.logs = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.returnCode.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.serialNumber);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putVariableOpaque(this.logs);
        xDROutputStream.setLength(n);
    }
}

