/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class DriveChannelErrorCounts
implements XDRType,
SYMbolAPIConstants {
    private int nonChannelErrors;
    private int timeoutErrors;
    private int controllerDetectedErrors;
    private int driveDetectedErrors;
    private int linkDownErrors;

    public DriveChannelErrorCounts() {
    }

    public DriveChannelErrorCounts(DriveChannelErrorCounts driveChannelErrorCounts) {
        this.nonChannelErrors = driveChannelErrorCounts.nonChannelErrors;
        this.timeoutErrors = driveChannelErrorCounts.timeoutErrors;
        this.controllerDetectedErrors = driveChannelErrorCounts.controllerDetectedErrors;
        this.driveDetectedErrors = driveChannelErrorCounts.driveDetectedErrors;
        this.linkDownErrors = driveChannelErrorCounts.linkDownErrors;
    }

    public int getControllerDetectedErrors() {
        return this.controllerDetectedErrors;
    }

    public int getDriveDetectedErrors() {
        return this.driveDetectedErrors;
    }

    public int getLinkDownErrors() {
        return this.linkDownErrors;
    }

    public int getNonChannelErrors() {
        return this.nonChannelErrors;
    }

    public int getTimeoutErrors() {
        return this.timeoutErrors;
    }

    public void setControllerDetectedErrors(int n) {
        this.controllerDetectedErrors = n;
    }

    public void setDriveDetectedErrors(int n) {
        this.driveDetectedErrors = n;
    }

    public void setLinkDownErrors(int n) {
        this.linkDownErrors = n;
    }

    public void setNonChannelErrors(int n) {
        this.nonChannelErrors = n;
    }

    public void setTimeoutErrors(int n) {
        this.timeoutErrors = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.nonChannelErrors = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.timeoutErrors = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.controllerDetectedErrors = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.driveDetectedErrors = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.linkDownErrors = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.nonChannelErrors);
        xDROutputStream.putInt(this.timeoutErrors);
        xDROutputStream.putInt(this.controllerDetectedErrors);
        xDROutputStream.putInt(this.driveDetectedErrors);
        xDROutputStream.putInt(this.linkDownErrors);
        xDROutputStream.setLength(n);
    }
}

