/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class AccessibleController
implements XDRType,
SYMbolAPIConstants {
    private int trayId;
    private int slot;
    private SAIdentifier saId = new SAIdentifier();
    private ControllerRef thisController = new ControllerRef();
    private ControllerRef[] allControllers;

    public AccessibleController() {
    }

    public AccessibleController(AccessibleController accessibleController) {
        this.trayId = accessibleController.trayId;
        this.slot = accessibleController.slot;
        this.saId = accessibleController.saId;
        this.thisController = accessibleController.thisController;
        this.allControllers = accessibleController.allControllers;
    }

    public ControllerRef[] getAllControllers() {
        return this.allControllers;
    }

    public SAIdentifier getSaId() {
        return this.saId;
    }

    public int getSlot() {
        return this.slot;
    }

    public ControllerRef getThisController() {
        return this.thisController;
    }

    public int getTrayId() {
        return this.trayId;
    }

    public void setAllControllers(ControllerRef[] controllerRefArray) {
        this.allControllers = controllerRefArray;
    }

    public void setSaId(SAIdentifier sAIdentifier) {
        this.saId = sAIdentifier;
    }

    public void setSlot(int n) {
        this.slot = n;
    }

    public void setThisController(ControllerRef controllerRef) {
        this.thisController = controllerRef;
    }

    public void setTrayId(int n) {
        this.trayId = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        this.trayId = xDRInputStream.getInt();
        this.slot = xDRInputStream.getInt();
        this.saId.xdrDecode(xDRInputStream);
        this.thisController.xdrDecode(xDRInputStream);
        int n = xDRInputStream.getInt();
        this.allControllers = new ControllerRef[n];
        int n2 = 0;
        while (n2 < n) {
            this.allControllers[n2] = new ControllerRef();
            this.allControllers[n2].xdrDecode(xDRInputStream);
            ++n2;
        }
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        xDROutputStream.putInt(this.trayId);
        xDROutputStream.putInt(this.slot);
        this.saId.xdrEncode(xDROutputStream);
        this.thisController.xdrEncode(xDROutputStream);
        int n = this.allControllers == null ? 0 : this.allControllers.length;
        xDROutputStream.putInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.allControllers[n2].xdrEncode(xDROutputStream);
            ++n2;
        }
    }
}

