/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.versioned.jrpc.RPCClientGeneric;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.TCPChannel;
import devmgr.versioned.jrpc.XDRMessageIOV;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

class RPCClientTCP
extends RPCClientGeneric {
    private static final int DEFAULT_TIMEOUT = 25;
    private TCPChannel m_Channel = null;

    RPCClientTCP(InetAddress inetAddress, int n, int n2, int n3) throws RPCError, IOException {
        super(n, n2);
        this.prepareConnection(inetAddress, n3);
    }

    public void close() throws IOException {
        this.m_Channel.close();
        this.m_Channel = null;
    }

    protected void finalize() throws Throwable {
        if (this.m_Channel != null) {
            this.m_Channel.close();
        }
    }

    public InetAddress getDestinationIP() {
        return this.m_Channel.getServerAddress();
    }

    public InetAddress getLocalAddress() {
        return this.m_Channel.getLocalAddress();
    }

    private void prepareConnection(InetAddress inetAddress, int n) throws IOException {
        this.m_Channel = new TCPChannel(new Socket(inetAddress, n));
        this.setTimeout(25);
    }

    public void setTimeout(int n) throws IOException {
        this.m_Channel.setTimeout(n);
    }

    public XDRMessageIOV transact(XDRMessageIOV xDRMessageIOV, int n) throws RPCError, IOException {
        this.m_Channel.sendMsg(xDRMessageIOV);
        return this.m_Channel.receiveMsg();
    }
}

