/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.RPCMsgConstants;
import devmgr.versioned.jrpc.RPCOpaqueAuth;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;

public class RPCCallMsg
implements XDRType,
RPCMsgConstants {
    private int rpcVersion;
    private int programNo;
    private int versionNo;
    private int procedure;
    private RPCOpaqueAuth credential = new RPCOpaqueAuth();
    private RPCOpaqueAuth verifier = new RPCOpaqueAuth();

    public RPCCallMsg() {
    }

    public RPCCallMsg(RPCCallMsg rPCCallMsg) {
        this.rpcVersion = rPCCallMsg.rpcVersion;
        this.programNo = rPCCallMsg.programNo;
        this.versionNo = rPCCallMsg.versionNo;
        this.procedure = rPCCallMsg.procedure;
        this.credential = rPCCallMsg.credential;
        this.verifier = rPCCallMsg.verifier;
    }

    public RPCOpaqueAuth getCredential() {
        return this.credential;
    }

    public int getProcedure() {
        return this.procedure;
    }

    public int getProgramNo() {
        return this.programNo;
    }

    public int getRpcVersion() {
        return this.rpcVersion;
    }

    public RPCOpaqueAuth getVerifier() {
        return this.verifier;
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public void setCredential(RPCOpaqueAuth rPCOpaqueAuth) {
        this.credential = rPCOpaqueAuth;
    }

    public void setProcedure(int n) {
        this.procedure = n;
    }

    public void setProgramNo(int n) {
        this.programNo = n;
    }

    public void setRpcVersion(int n) {
        this.rpcVersion = n;
    }

    public void setVerifier(RPCOpaqueAuth rPCOpaqueAuth) {
        this.verifier = rPCOpaqueAuth;
    }

    public void setVersionNo(int n) {
        this.versionNo = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        this.rpcVersion = xDRInputStream.getInt();
        this.programNo = xDRInputStream.getInt();
        this.versionNo = xDRInputStream.getInt();
        this.procedure = xDRInputStream.getInt();
        this.credential.xdrDecode(xDRInputStream);
        this.verifier.xdrDecode(xDRInputStream);
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        xDROutputStream.putInt(this.rpcVersion);
        xDROutputStream.putInt(this.programNo);
        xDROutputStream.putInt(this.versionNo);
        xDROutputStream.putInt(this.procedure);
        this.credential.xdrEncode(xDROutputStream);
        this.verifier.xdrEncode(xDROutputStream);
    }
}

