/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.system;

import com.sun.jade.util.log.Report;
import java.io.FileInputStream;
import java.util.Properties;

public final class Configuration {
    private static Properties configProperties;
    private static final String TR_POSTGRESQL_PORT = "TR_POSTGRESQL_PORT";
    private static final String TR_REGISTRY_HOST = "TR_REGISTRY_HOST";
    private static final String TR_RMI_REGISTRY_PORT = "TR_RMI_REGISTRY_PORT";
    private static final String TR_PROPERTIES = "sstr.properties";
    private static final String CONFIG_PROP_FILE = "/opt/SUNWstm/sssm/etc/sstr.properties";
    private static final String CONFIGURATION_FILE = "esm.configuration";
    private static final int DEFAULT_RMI_PORT = 1099;
    private static final int DEFAULT_DB_PORT = 5437;
    public static final String sccs_id = "@(#)Configuration.java\t1.4 08/28/03 SMI";

    public static int getRMIRegistryPort() {
        try {
            Properties properties = Configuration.getConfigurationProperties();
            return Integer.parseInt(properties.getProperty(TR_RMI_REGISTRY_PORT));
        }
        catch (Exception exception) {
            Report.warning.log(exception, (Object)"Error getting RMI Port, will use default.");
            return 1099;
        }
    }

    public static int getDBPort() {
        try {
            Properties properties = Configuration.getConfigurationProperties();
            return Integer.parseInt(properties.getProperty(TR_POSTGRESQL_PORT));
        }
        catch (Exception exception) {
            Report.warning.log(exception, (Object)"Error getting DB Port, will use default.");
            return 5437;
        }
    }

    public static String getRMIRegistryHost() {
        Properties properties = Configuration.getConfigurationProperties();
        return properties.getProperty(TR_REGISTRY_HOST);
    }

    public static Properties getConfigurationProperties() {
        if (configProperties != null) {
            return configProperties;
        }
        try {
            String string = System.getProperty(CONFIGURATION_FILE);
            if (string == null) {
                string = CONFIG_PROP_FILE;
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            return properties;
        }
        catch (Exception exception) {
            Report.warning.log(exception, (Object)"Error getting configuration, will use defaults.");
            return new Properties();
        }
    }
}

