/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.rmi;

import com.sun.netstorage.mgmt.esm.util.rmi.RMISSLConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class RMISSLClientSocketFactory
implements RMIClientSocketFactory,
RMISSLConstants,
Serializable {
    static final long serialVersionUID = 8863107404685095386L;
    private SSLContext sslContext;
    private final Integer stateLock = new Integer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocket(String string, int n) throws IOException {
        try {
            Integer n2 = this.stateLock;
            synchronized (n2) {
                if (this.sslContext == null) {
                    this.initializeSSLContext();
                }
            }
            return this.sslContext.getSocketFactory().createSocket(string, n);
        }
        catch (Exception exception) {
            throw new RemoteException("Failure creating socket", exception);
        }
    }

    private void initializeSSLContext() throws IOException, GeneralSecurityException {
        this.initializeKeystorePasswords();
        char[] cArray = System.getProperty("esm.util.rmi.keystore_pwd").toCharArray();
        FileInputStream fileInputStream = new FileInputStream(System.getProperty("esm.util.rmi.keystore"));
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(fileInputStream, cArray);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, cArray);
        char[] cArray2 = System.getProperty("esm.util.rmi.truststore_pwd").toCharArray();
        FileInputStream fileInputStream2 = new FileInputStream(System.getProperty("esm.util.rmi.truststore"));
        KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore2.load(fileInputStream2, cArray2);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore2);
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
    }

    private void initializeKeystorePasswords() {
        if (System.getProperty("esm.util.rmi.pwd_filename") == null) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(System.getProperty("esm.util.rmi.pwd_filename")));
            System.setProperty("esm.util.rmi.keystore_pwd", properties.getProperty("keystore_pwd", System.getProperty("esm.util.rmi.keystore_pwd")));
            System.setProperty("esm.util.rmi.truststore_pwd", properties.getProperty("truststore_pwd", System.getProperty("esm.util.rmi.truststore_pwd")));
        }
        catch (Exception exception) {
            return;
        }
    }
}

