/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.persistence;

import com.sun.netstorage.mgmt.esm.util.persistence.PersistentPropertiesException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class PersistentProperties {
    private static final String SCCS_ID = "@(#)PersistentProperties.java 1.2   03/04/07 SMI";
    public static final String USER_HOME = "user.home";
    public static final String DIR_NAME_PROPERTY = "PersistentProperties.dirname";
    public static final String DIR_NAME_DEFAULT = "/etc";
    public static final String BASE_NAME_PROPERTY = "PersistentProperties.basename";
    public static final String BASE_NAME_DEFAULT = "persistence";
    public static final String SUFFIX_PROPERTY = "PersistentProperties.suffix";
    public static final String SUFFIX_DEFAULT = "properties";
    private final Class myOwner;
    private String myDirName = null;
    private String myBaseName = null;
    private String mySuffix = null;
    private String myFileName = null;
    private File myPersistence = null;
    private final Properties myProperties = new Properties();
    private boolean myLoaded = false;
    private boolean myDirtyBit = false;

    public static String getDirNameDefault() {
        return System.getProperty(USER_HOME, DIR_NAME_DEFAULT);
    }

    public static String getDirNameProperty() {
        return System.getProperty(DIR_NAME_PROPERTY, PersistentProperties.getDirNameDefault());
    }

    public static String getBaseNameProperty() {
        return System.getProperty(BASE_NAME_PROPERTY, null);
    }

    public static String getSuffixProperty() {
        return System.getProperty(SUFFIX_PROPERTY, SUFFIX_DEFAULT);
    }

    public PersistentProperties(Class clazz, String string, String string2, String string3) {
        this.myOwner = clazz;
        this.myDirName = string;
        this.myBaseName = string2;
        this.mySuffix = string3;
    }

    public PersistentProperties(Class clazz, String string, String string2) {
        this(clazz, string, string2, null);
    }

    public PersistentProperties(Class clazz, String string) {
        this(clazz, string, null);
    }

    public PersistentProperties(Class clazz) {
        this(clazz, null);
    }

    public final Class getOwner() {
        return this.myOwner;
    }

    public final String getOwnerBasename() {
        String string = this.getOwnerFullname();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    public final String getOwnerFullname() {
        String string = this.myOwner.getName();
        return string;
    }

    public final String getDirName() {
        if (this.myDirName == null) {
            this.myDirName = PersistentProperties.getDirNameProperty();
        }
        return this.myDirName;
    }

    public final void setDirName(String string) {
        if (this.myDirName == null) {
            this.myDirName = string;
        }
    }

    private File getDirFile() throws PersistentPropertiesException {
        File file = new File(this.getDirName());
        if (!file.exists()) {
            throw new PersistentPropertiesException.DirDoesNotExist(file);
        }
        return file;
    }

    public final String getBaseName() {
        if (this.myBaseName == null) {
            this.myBaseName = PersistentProperties.getBaseNameProperty();
            if (this.myBaseName == null) {
                this.myBaseName = this.getBaseNameDefault();
            }
        }
        return this.myBaseName;
    }

    public final String getBaseNameDefault() {
        return this.getOwnerBasename();
    }

    public final void setBaseName(String string) {
        if (this.myBaseName == null) {
            this.myBaseName = string;
        }
    }

    public final String getSuffix() {
        if (this.mySuffix == null) {
            this.mySuffix = PersistentProperties.getSuffixProperty();
        }
        return this.mySuffix;
    }

    public final void setSuffix(String string) {
        if (this.mySuffix == null) {
            this.mySuffix = string;
        }
    }

    private String getFileName() {
        if (this.myFileName == null) {
            String string = this.getBaseName();
            String string2 = this.getSuffix();
            this.myFileName = string + '.' + string2;
        }
        return this.myFileName;
    }

    private File getPersistence() throws PersistentPropertiesException {
        if (this.myPersistence == null) {
            File file = this.getDirFile();
            String string = this.getFileName();
            this.myPersistence = new File(file, string);
        }
        return this.myPersistence;
    }

    public final Properties getProperties() throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties;
    }

    public final String getProperty(String string, String string2) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.getProperty(string, string2);
    }

    public final String getProperty(String string) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.getProperty(string);
    }

    public final void setProperty(String string, String string2, boolean bl) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        this.myProperties.setProperty(string, string2);
        this.setDirty();
        if (bl) {
            this.store();
        }
    }

    public final void setProperty(String string, String string2) throws PersistentPropertiesException {
        this.setProperty(string, string2, true);
    }

    public final void remove(String string) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        if (this.myProperties.containsKey(string)) {
            this.myProperties.remove(string);
            this.store();
        }
    }

    public final boolean containsKey(String string) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.containsKey(string);
    }

    public final boolean containsValue(String string) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.containsValue(string);
    }

    public final Set keySet() throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.keySet();
    }

    public final Set entrySet() throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.entrySet();
    }

    public final Collection values() throws PersistentPropertiesException {
        this.loadWhenNecessary();
        return this.myProperties.values();
    }

    private void loadWhenNecessary() throws PersistentPropertiesException {
        if (!this.isLoaded()) {
            this.load();
        }
    }

    public final void load() throws PersistentPropertiesException {
        if (!this.isLoaded()) {
            File file = this.getPersistence();
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.myProperties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                }
                this.setLoaded();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PersistentPropertiesException.FileNotFound(fileNotFoundException, file);
            }
            catch (IOException iOException) {
                throw new PersistentPropertiesException.LoadFailure(iOException, file);
            }
        }
    }

    public final void store() throws PersistentPropertiesException {
        Object object;
        if (this.isDirty()) {
            // empty if block
        }
        File file = this.getPersistence();
        File file2 = null;
        if (file.exists()) {
            object = file.getAbsolutePath() + ".save";
            file2 = new File((String)object);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        try {
            object = new FileOutputStream(file);
            String string = this.getPersistenceHeader();
            this.myProperties.store((OutputStream)object, string);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            this.resetDirty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PersistentPropertiesException.FileNotFound(fileNotFoundException, file);
        }
        catch (IOException iOException) {
            throw new PersistentPropertiesException.StoreFailure(iOException, file);
        }
        if (file2 != null && file2.exists()) {
            file2.delete();
        }
    }

    public final void list(PrintStream printStream) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        this.myProperties.list(printStream);
    }

    public final void list(PrintWriter printWriter) throws PersistentPropertiesException {
        this.loadWhenNecessary();
        this.myProperties.list(printWriter);
    }

    public final boolean isLoaded() {
        return this.myLoaded;
    }

    private void resetLoaded() {
        this.myLoaded = false;
    }

    private void setLoaded() {
        this.myLoaded = true;
    }

    public final boolean isDirty() {
        return this.myDirtyBit;
    }

    private void resetDirty() {
        this.myDirtyBit = false;
    }

    private void setDirty() {
        this.myDirtyBit = true;
    }

    private String getPersistenceHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" PersistentProperties\n");
        stringBuffer.append("########################################");
        stringBuffer.append("########################################\n");
        stringBuffer.append("#\n");
        stringBuffer.append("# Generated by: ");
        stringBuffer.append(this.getOwnerFullname());
        stringBuffer.append('\n');
        stringBuffer.append("# Generated on: ");
        stringBuffer.append(new Date());
        stringBuffer.append('\n');
        stringBuffer.append("#\n");
        stringBuffer.append("#    Transient Data: DO NOT EDIT THIS FILE BY HAND!\n");
        stringBuffer.append("#\n");
        stringBuffer.append("########################################");
        stringBuffer.append("########################################\n");
        return stringBuffer.toString();
    }

    protected void finalize() throws Throwable {
        block2: {
            super.finalize();
            if (!this.isDirty()) break block2;
            try {
                this.store();
            }
            catch (Throwable throwable) {}
        }
    }
}

