/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.component.model.engine;

import com.sun.netstorage.mgmt.component.model.engine.ConnectionException;
import com.sun.netstorage.mgmt.component.model.engine.ConnectionPool;
import com.sun.netstorage.mgmt.component.model.engine.Localize;
import com.sun.netstorage.mgmt.component.model.engine.PersistenceException;
import com.sun.netstorage.mgmt.component.model.engine.Transaction;
import com.sun.netstorage.mgmt.component.model.engine.TransactionException;
import com.sun.netstorage.mgmt.component.model.engine.TransactionImpl;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.Properties;

public class PersistenceManager {
    private ConnectionPool pool_;
    private static Properties dbProperties_ = null;
    private static PersistenceManager theInstance_ = null;
    private static final int DEFAULT_INIT_CONNS = 2;
    private static final int DEFAULT_MAX_CONNS = 5;
    private static final long DEFAULT_TIMEOUT = 10000L;
    private static final String DRIVER_KEY = "database.driver.class";
    private static final String URL_KEY = "database.url";
    private static final String NUM_CONNS_KEY = "initial.connections";
    private static final String MAX_CONNS_KEY = "max.connections";
    private static final String TIMEOUT_KEY = "timeout";
    private static final String CONFIG_PROPERTY = "nsm.configuration";
    private static final String HOST_KEY = "NSM_DATABASE_HOST";
    private static final String PORT_KEY = "NSM_POSTGRESQL_PORT";
    private static final String DB_NAME_KEY = "NSM_DATABASE_NAME";
    private static final String USER_KEY = "NSM_DATABASE_USER";
    private static final String PW_KEY = "NSM_DATABASE_PW";
    private static final String DEFAULT_CONFIG_FILE = "/opt/SUNWnsm/etc/sstr.properties";
    static final String sccs_id = "@(#)PersistenceManager.java 1.12   02/02/21 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$component$model$engine$PersistenceManager;

    private PersistenceManager(String string, String string2, String string3) throws SQLException, ClassNotFoundException {
        String string4 = Localize.getString(this.getClass(), DRIVER_KEY);
        int n = 2;
        try {
            n = Integer.parseInt(Localize.getString(this.getClass(), NUM_CONNS_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = 5;
        try {
            n2 = Integer.parseInt(Localize.getString(this.getClass(), MAX_CONNS_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long l = 10000L;
        try {
            l = Long.parseLong(Localize.getString(this.getClass(), TIMEOUT_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.initializePool(string4, string, string2, string3, n, n2, l);
    }

    private PersistenceManager() throws SQLException, ClassNotFoundException, PersistenceException {
        this(Localize.getString(class$com$sun$netstorage$mgmt$component$model$engine$PersistenceManager == null ? (class$com$sun$netstorage$mgmt$component$model$engine$PersistenceManager = PersistenceManager.class$("com.sun.netstorage.mgmt.component.model.engine.PersistenceManager")) : class$com$sun$netstorage$mgmt$component$model$engine$PersistenceManager, URL_KEY, new Object[]{PersistenceManager.getProperty(HOST_KEY, "localhost"), PersistenceManager.getProperty(PORT_KEY, "5437"), PersistenceManager.getProperty(DB_NAME_KEY, "nsm1")}), PersistenceManager.getProperty(USER_KEY, "nsm1"), PersistenceManager.getProperty(PW_KEY, "nsm1"));
    }

    private void initializePool(String string, String string2, String string3, String string4, int n, int n2, long l) throws SQLException, ClassNotFoundException {
        this.pool_ = new ConnectionPool(string, string2, string3, string4, n, n2, l);
    }

    public static synchronized PersistenceManager getInstance() throws PersistenceException {
        try {
            if (theInstance_ == null) {
                theInstance_ = new PersistenceManager();
            }
            return theInstance_;
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    public static synchronized PersistenceManager getInstance(String string, String string2, String string3) throws PersistenceException {
        try {
            if (theInstance_ == null) {
                theInstance_ = new PersistenceManager(string, string2, string3);
            }
            return theInstance_;
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
    }

    public Transaction getTransaction() throws TransactionException {
        try {
            return new TransactionImpl(this.pool_);
        }
        catch (ConnectionException connectionException) {
            throw new TransactionException(connectionException);
        }
    }

    public void releaseTransaction(Transaction transaction) {
        this.releaseTransaction((TransactionImpl)transaction);
    }

    private void releaseTransaction(TransactionImpl transactionImpl) {
        if (transactionImpl != null) {
            transactionImpl.freeUp();
        }
    }

    private static synchronized String getProperty(String string, String string2) throws PersistenceException {
        if (dbProperties_ == null) {
            try {
                String string3 = System.getProperty(CONFIG_PROPERTY);
                if (string3 == null) {
                    string3 = DEFAULT_CONFIG_FILE;
                }
                dbProperties_ = new Properties();
                dbProperties_.load(new FileInputStream(string3));
            }
            catch (Exception exception) {
                dbProperties_ = null;
                throw new PersistenceException(exception);
            }
        }
        return dbProperties_.getProperty(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

