/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.symbol;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import devmgr.v0912api01.symbol.DriveRef;
import devmgr.v0912api01.symbol.DriveStatus;
import devmgr.v0912api01.symbol.DriveStatusCause;
import devmgr.v0912api01.symbol.DriveTypeData;
import devmgr.v0912api01.symbol.InterfaceSpeed;
import devmgr.v0912api01.symbol.Location;
import devmgr.v0912api01.symbol.PhysicalDriveType;
import devmgr.v0912api01.symbol.SYMbolAPIConstants;
import devmgr.v0912api01.symbol.VolumeGroupRef;

public class Drive
implements XDRType,
SYMbolAPIConstants {
    private boolean offline;
    private boolean hotSpare;
    private boolean invalidDriveData;
    private boolean available;
    private boolean pfa;
    private DriveRef driveRef = new DriveRef();
    private DriveStatus status = new DriveStatus();
    private DriveStatusCause cause = new DriveStatusCause();
    private DriveTypeData interfaceType = new DriveTypeData();
    private Location physicalLocation = new Location();
    private String manufacturer;
    private long manufacturerDate;
    private String productID;
    private String serialNumber;
    private String softwareVersion;
    private int blkSize;
    private long usableCapacity;
    private long rawCapacity;
    private byte[] worldWideName;
    private VolumeGroupRef currentVolumeGroupRef = new VolumeGroupRef();
    private DriveRef sparedForDriveRef = new DriveRef();
    private DriveRef mirrorDrive = new DriveRef();
    private boolean nonRedundantAccess;
    private int workingChannel;
    private int volumeGroupIndex;
    private InterfaceSpeed currentSpeed = new InterfaceSpeed();
    private InterfaceSpeed maxSpeed = new InterfaceSpeed();
    private boolean uncertified;
    private boolean hasDegradedChannel;
    private int[] degradedChannels;
    private PhysicalDriveType phyDriveType = new PhysicalDriveType();
    private int spindleSpeed;

    public Drive() {
    }

    public Drive(Drive drive) {
        this.offline = drive.offline;
        this.hotSpare = drive.hotSpare;
        this.invalidDriveData = drive.invalidDriveData;
        this.available = drive.available;
        this.pfa = drive.pfa;
        this.driveRef = drive.driveRef;
        this.status = drive.status;
        this.cause = drive.cause;
        this.interfaceType = drive.interfaceType;
        this.physicalLocation = drive.physicalLocation;
        this.manufacturer = drive.manufacturer;
        this.manufacturerDate = drive.manufacturerDate;
        this.productID = drive.productID;
        this.serialNumber = drive.serialNumber;
        this.softwareVersion = drive.softwareVersion;
        this.blkSize = drive.blkSize;
        this.usableCapacity = drive.usableCapacity;
        this.rawCapacity = drive.rawCapacity;
        this.worldWideName = drive.worldWideName;
        this.currentVolumeGroupRef = drive.currentVolumeGroupRef;
        this.sparedForDriveRef = drive.sparedForDriveRef;
        this.mirrorDrive = drive.mirrorDrive;
        this.nonRedundantAccess = drive.nonRedundantAccess;
        this.workingChannel = drive.workingChannel;
        this.volumeGroupIndex = drive.volumeGroupIndex;
        this.currentSpeed = drive.currentSpeed;
        this.maxSpeed = drive.maxSpeed;
        this.uncertified = drive.uncertified;
        this.hasDegradedChannel = drive.hasDegradedChannel;
        this.degradedChannels = drive.degradedChannels;
        this.phyDriveType = drive.phyDriveType;
        this.spindleSpeed = drive.spindleSpeed;
    }

    public boolean getAvailable() {
        return this.available;
    }

    public int getBlkSize() {
        return this.blkSize;
    }

    public DriveStatusCause getCause() {
        return this.cause;
    }

    public InterfaceSpeed getCurrentSpeed() {
        return this.currentSpeed;
    }

    public VolumeGroupRef getCurrentVolumeGroupRef() {
        return this.currentVolumeGroupRef;
    }

    public int[] getDegradedChannels() {
        return this.degradedChannels;
    }

    public DriveRef getDriveRef() {
        return this.driveRef;
    }

    public boolean getHasDegradedChannel() {
        return this.hasDegradedChannel;
    }

    public boolean getHotSpare() {
        return this.hotSpare;
    }

    public DriveTypeData getInterfaceType() {
        return this.interfaceType;
    }

    public boolean getInvalidDriveData() {
        return this.invalidDriveData;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public InterfaceSpeed getMaxSpeed() {
        return this.maxSpeed;
    }

    public DriveRef getMirrorDrive() {
        return this.mirrorDrive;
    }

    public boolean getNonRedundantAccess() {
        return this.nonRedundantAccess;
    }

    public boolean getOffline() {
        return this.offline;
    }

    public boolean getPfa() {
        return this.pfa;
    }

    public PhysicalDriveType getPhyDriveType() {
        return this.phyDriveType;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public String getProductID() {
        return this.productID;
    }

    public long getRawCapacity() {
        return this.rawCapacity;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public DriveRef getSparedForDriveRef() {
        return this.sparedForDriveRef;
    }

    public int getSpindleSpeed() {
        return this.spindleSpeed;
    }

    public DriveStatus getStatus() {
        return this.status;
    }

    public boolean getUncertified() {
        return this.uncertified;
    }

    public long getUsableCapacity() {
        return this.usableCapacity;
    }

    public int getVolumeGroupIndex() {
        return this.volumeGroupIndex;
    }

    public int getWorkingChannel() {
        return this.workingChannel;
    }

    public byte[] getWorldWideName() {
        return this.worldWideName;
    }

    public void setAvailable(boolean bl) {
        this.available = bl;
    }

    public void setBlkSize(int n) {
        this.blkSize = n;
    }

    public void setCause(DriveStatusCause driveStatusCause) {
        this.cause = driveStatusCause;
    }

    public void setCurrentSpeed(InterfaceSpeed interfaceSpeed) {
        this.currentSpeed = interfaceSpeed;
    }

    public void setCurrentVolumeGroupRef(VolumeGroupRef volumeGroupRef) {
        this.currentVolumeGroupRef = volumeGroupRef;
    }

    public void setDegradedChannels(int[] nArray) {
        this.degradedChannels = nArray;
    }

    public void setDriveRef(DriveRef driveRef) {
        this.driveRef = driveRef;
    }

    public void setHasDegradedChannel(boolean bl) {
        this.hasDegradedChannel = bl;
    }

    public void setHotSpare(boolean bl) {
        this.hotSpare = bl;
    }

    public void setInterfaceType(DriveTypeData driveTypeData) {
        this.interfaceType = driveTypeData;
    }

    public void setInvalidDriveData(boolean bl) {
        this.invalidDriveData = bl;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public void setMaxSpeed(InterfaceSpeed interfaceSpeed) {
        this.maxSpeed = interfaceSpeed;
    }

    public void setMirrorDrive(DriveRef driveRef) {
        this.mirrorDrive = driveRef;
    }

    public void setNonRedundantAccess(boolean bl) {
        this.nonRedundantAccess = bl;
    }

    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    public void setPfa(boolean bl) {
        this.pfa = bl;
    }

    public void setPhyDriveType(PhysicalDriveType physicalDriveType) {
        this.phyDriveType = physicalDriveType;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setProductID(String string) {
        this.productID = string;
    }

    public void setRawCapacity(long l) {
        this.rawCapacity = l;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void setSoftwareVersion(String string) {
        this.softwareVersion = string;
    }

    public void setSparedForDriveRef(DriveRef driveRef) {
        this.sparedForDriveRef = driveRef;
    }

    public void setSpindleSpeed(int n) {
        this.spindleSpeed = n;
    }

    public void setStatus(DriveStatus driveStatus) {
        this.status = driveStatus;
    }

    public void setUncertified(boolean bl) {
        this.uncertified = bl;
    }

    public void setUsableCapacity(long l) {
        this.usableCapacity = l;
    }

    public void setVolumeGroupIndex(int n) {
        this.volumeGroupIndex = n;
    }

    public void setWorkingChannel(int n) {
        this.workingChannel = n;
    }

    public void setWorldWideName(byte[] byArray) {
        this.worldWideName = byArray;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.offline = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.hotSpare = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.invalidDriveData = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.available = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.pfa = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.driveRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.cause.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.interfaceType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturer = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.productID = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.softwareVersion = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.blkSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.usableCapacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.rawCapacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.worldWideName = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentVolumeGroupRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.sparedForDriveRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.mirrorDrive.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.nonRedundantAccess = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.workingChannel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupIndex = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.maxSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.uncertified = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.hasDegradedChannel = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            int n2 = xDRInputStream.getInt();
            this.degradedChannels = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.degradedChannels[n3] = xDRInputStream.getInt();
                ++n3;
            }
        }
        if (xDRInputStream.getPosition() < n) {
            this.phyDriveType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.spindleSpeed = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putBoolean(this.offline);
        xDROutputStream.putBoolean(this.hotSpare);
        xDROutputStream.putBoolean(this.invalidDriveData);
        xDROutputStream.putBoolean(this.available);
        xDROutputStream.putBoolean(this.pfa);
        this.driveRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.cause.xdrEncode(xDROutputStream);
        this.interfaceType.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.manufacturer);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putString(this.productID);
        xDROutputStream.putString(this.serialNumber);
        xDROutputStream.putString(this.softwareVersion);
        xDROutputStream.putInt(this.blkSize);
        xDROutputStream.putLong(this.usableCapacity);
        xDROutputStream.putLong(this.rawCapacity);
        xDROutputStream.putVariableOpaque(this.worldWideName);
        this.currentVolumeGroupRef.xdrEncode(xDROutputStream);
        this.sparedForDriveRef.xdrEncode(xDROutputStream);
        this.mirrorDrive.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.nonRedundantAccess);
        xDROutputStream.putInt(this.workingChannel);
        xDROutputStream.putInt(this.volumeGroupIndex);
        this.currentSpeed.xdrEncode(xDROutputStream);
        this.maxSpeed.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.uncertified);
        xDROutputStream.putBoolean(this.hasDegradedChannel);
        int n2 = this.degradedChannels == null ? 0 : this.degradedChannels.length;
        xDROutputStream.putInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            xDROutputStream.putInt(this.degradedChannels[n3]);
            ++n3;
        }
        this.phyDriveType.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.spindleSpeed);
        xDROutputStream.setLength(n);
    }
}

