/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.symbol;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import devmgr.v0912api01.symbol.AccessibleController;
import devmgr.v0912api01.symbol.SYMbolAPIConstants;

public class DiscoveryResponse
implements XDRType,
SYMbolAPIConstants {
    private boolean responseFromAgent;
    private byte[] agentId;
    private AccessibleController[] controllers;

    public DiscoveryResponse() {
    }

    public DiscoveryResponse(DiscoveryResponse discoveryResponse) {
        this.responseFromAgent = discoveryResponse.responseFromAgent;
        this.agentId = discoveryResponse.agentId;
        this.controllers = discoveryResponse.controllers;
    }

    public byte[] getAgentId() {
        return this.agentId;
    }

    public AccessibleController[] getControllers() {
        return this.controllers;
    }

    public boolean getResponseFromAgent() {
        return this.responseFromAgent;
    }

    public void setAgentId(byte[] byArray) {
        this.agentId = byArray;
    }

    public void setControllers(AccessibleController[] accessibleControllerArray) {
        this.controllers = accessibleControllerArray;
    }

    public void setResponseFromAgent(boolean bl) {
        this.responseFromAgent = bl;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        this.responseFromAgent = xDRInputStream.getBoolean();
        this.agentId = xDRInputStream.getVariableOpaque();
        int n = xDRInputStream.getInt();
        this.controllers = new AccessibleController[n];
        int n2 = 0;
        while (n2 < n) {
            this.controllers[n2] = new AccessibleController();
            this.controllers[n2].xdrDecode(xDRInputStream);
            ++n2;
        }
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        xDROutputStream.putBoolean(this.responseFromAgent);
        xDROutputStream.putVariableOpaque(this.agentId);
        int n = this.controllers == null ? 0 : this.controllers.length;
        xDROutputStream.putInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.controllers[n2].xdrEncode(xDROutputStream);
            ++n2;
        }
    }
}

