/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.jrpc;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.UDPMessageBundle;
import devmgr.v0912api01.jrpc.XDRMessageIOV;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

class UDPChannel {
    private static final int MAX_MSG_SIZE = 8800;
    private DatagramSocket m_Sock = null;

    UDPChannel(DatagramSocket datagramSocket) {
        this.m_Sock = datagramSocket;
    }

    void close() throws IOException {
        this.m_Sock.close();
        this.m_Sock = null;
    }

    protected void finalize() throws Throwable {
        if (this.m_Sock != null) {
            this.m_Sock.close();
        }
    }

    public InetAddress getLocalAddress() {
        return this.m_Sock.getLocalAddress();
    }

    UDPMessageBundle receiveMsg() throws RPCError, IOException {
        XDRMessageIOV xDRMessageIOV = new XDRMessageIOV();
        byte[] byArray = new byte[8800];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 8800);
        this.m_Sock.receive(datagramPacket);
        xDRMessageIOV.addLastBuffer(byArray, datagramPacket.getLength());
        UDPMessageBundle uDPMessageBundle = new UDPMessageBundle(xDRMessageIOV, datagramPacket.getAddress(), datagramPacket.getPort());
        return uDPMessageBundle;
    }

    void sendMsg(UDPMessageBundle uDPMessageBundle) throws RPCError, IOException {
        XDRMessageIOV xDRMessageIOV = uDPMessageBundle.getMsg();
        int n = xDRMessageIOV.getMessageSize();
        DatagramPacket datagramPacket = null;
        byte[] byArray = xDRMessageIOV.getContiguousBuffer();
        datagramPacket = new DatagramPacket(byArray, n, uDPMessageBundle.getAddress(), uDPMessageBundle.getPort());
        this.m_Sock.send(datagramPacket);
    }

    void setTimeout(int n) throws IOException {
        this.m_Sock.setSoTimeout(n);
    }
}

