/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.lock;

import com.sun.netstorage.fm.storade.util.StoradeDate;
import java.util.Date;

public class LockInfo {
    private String resourceName;
    private String pid;
    private String application;
    private String description;
    private Date startDate;
    private int duration;
    private int secondsRemaining;
    private String ip;
    private String user;
    private boolean locked;
    public static final String cvs_id = "$Id: LockInfo.java,v 1.7 2004/08/27 23:46:25 jkremer Exp $";

    public LockInfo() {
    }

    public LockInfo(String resourceName, String application, String description, Date startDate, int duration, String ip, String user) {
        this.resourceName = resourceName;
        this.application = application;
        this.description = description;
        this.startDate = startDate;
        this.duration = duration;
        this.ip = ip;
        this.user = user;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getPid() {
        return this.pid;
    }

    public String getApplication() {
        return this.application;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getIpAddress() {
        return this.ip;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getSecondsRemaining() {
        return this.secondsRemaining;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setSecondsRemaining(int secondsRemaining) {
        this.secondsRemaining = secondsRemaining;
    }

    public void parseInfo(String info) {
        this.application = null;
        this.description = null;
        this.startDate = null;
        this.duration = 0;
        this.ip = null;
        this.user = null;
        try {
            int index = info.indexOf("|");
            if (index < 0) {
                return;
            }
            this.application = info.substring(0, index);
            if ((index = (info = info.substring(index + 1)).indexOf("|")) < 0) {
                return;
            }
            String resourceKey = info.substring(0, index);
            if ((index = (info = info.substring(index + 1)).indexOf("|")) < 0) {
                return;
            }
            this.description = info.substring(0, index);
            if ((index = (info = info.substring(index + 1)).indexOf("|")) < 0) {
                return;
            }
            StoradeDate sadate = new StoradeDate(info.substring(0, index));
            this.startDate = sadate.getDate();
            if ((index = (info = info.substring(index + 1)).indexOf("|")) < 0) {
                return;
            }
            try {
                this.duration = (int)Float.parseFloat(info.substring(0, index));
            }
            catch (Exception e) {
                this.duration = 0;
            }
            info = info.substring(index + 1);
            index = info.indexOf("|");
            if (index < 0) {
                return;
            }
            this.ip = info.substring(0, index);
            this.user = info.substring(index + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<LOCK_INFO>");
        sb.append("<RESOURCE>" + this.resourceName + "</RESOURCE>");
        sb.append("<LOCKED>");
        if (this.locked) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        sb.append("</LOCKED>");
        sb.append("<TIME_LEFT>" + this.secondsRemaining + "</TIME_LEFT>");
        sb.append("<INFO>");
        sb.append(this.application + "|");
        sb.append(this.resourceName + "|");
        sb.append(this.description + "|");
        StoradeDate sd = new StoradeDate(this.startDate);
        sb.append(sd.getDateString() + "|");
        sb.append(Integer.toString(this.duration) + "|");
        sb.append(this.ip + "|");
        sb.append("user");
        sb.append("</INFO>");
        sb.append("<PID>" + this.pid + "</PID>");
        return sb.toString();
    }
}

