/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.agent;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.logging.Logger;

public class AgentSummary
implements Serializable {
    public static final String MASTER_ROLE = "M";
    public static final String SLAVE_ROLE = "S";
    private String hostid;
    private String hostname;
    private String ipno;
    private String agent_version;
    private String role;
    private String solution_model;
    private String ports_connected;
    private String ports_notconnected;
    public static final String sccs_id = "@(#)StoradeAgentSummary.java 1.4     03/11/21 SMI";

    public AgentSummary(String hostid, String hostname, String ipno, String version, String role, String model, int ports_connected, int ports_not_connected) {
        this.hostid = hostid;
        this.hostname = hostname;
        this.ipno = ipno;
        this.agent_version = version;
        this.role = role;
        this.solution_model = model;
        this.ports_connected = Integer.toString(ports_connected);
        this.ports_notconnected = Integer.toString(ports_not_connected);
    }

    public AgentSummary(Properties p) {
        this.hostid = p.getProperty("hostid");
        this.hostname = p.getProperty("hostname");
        this.ipno = p.getProperty("ipno");
        this.agent_version = p.getProperty("agent_version");
        this.role = p.getProperty("role");
        this.solution_model = p.getProperty("solution_model");
        this.ports_connected = p.getProperty("ports_connected");
        this.ports_notconnected = p.getProperty("ports_notconnected");
    }

    public String getHostId() {
        return this.hostid;
    }

    public String getHostName() {
        return this.hostname;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.ipno);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAgentVersion() {
        return this.agent_version;
    }

    public boolean isMaster() {
        return MASTER_ROLE.equals(this.role);
    }

    public String getSolutionModel() {
        return this.solution_model;
    }

    public String getPortsConnected() {
        return this.ports_connected;
    }

    public String getPortsNotConnected() {
        return this.ports_notconnected;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hostid);
        sb.append(":");
        sb.append(this.hostname);
        sb.append(":");
        sb.append(this.ipno);
        sb.append(":");
        sb.append(this.agent_version);
        sb.append(":");
        sb.append(this.role);
        sb.append(":");
        sb.append(this.solution_model);
        sb.append(":");
        sb.append(this.ports_connected);
        sb.append(":");
        sb.append(this.ports_notconnected);
        return sb.toString();
    }

    private static Logger getLogger() {
        return Logger.getLogger("com.sun.netstorage.fm.storade.service");
    }
}

