/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.util.Roles;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sun.misc.BASE64Encoder;

public class HTTPConnection {
    static Logger logger = Logger.getLogger("com.sun.netstorage.fm.storade.client.http");
    private String protocol;
    private String host;
    private int port;
    private String user;
    private String password;
    private String method = "GET";
    private static int DEFAULT_TIMEOUT = 120;
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    private boolean abortConnection;
    private IOException connectException;
    private boolean connecting;

    public HTTPConnection(URL url) {
        this.host = url.getHost();
        this.port = url.getPort();
        this.protocol = url.getProtocol();
    }

    public HTTPConnection(URL url, String user, String password) {
        this.host = url.getHost();
        this.port = url.getPort();
        this.protocol = url.getProtocol();
        this.user = user;
        this.password = password;
    }

    public void setCredentials(String user, String pass) {
        this.user = user;
        this.password = pass;
    }

    public String getData(String request, int timeout) {
        HTTPResponse response = this.getResponse(request, timeout);
        return response.getData();
    }

    public synchronized HTTPResponse postResponse(String request, String post, int timeout) {
        HTTPResponse response = new HTTPResponse();
        HttpURLConnection connection = null;
        try {
            String line;
            connection = this.openConnection(request, this.protocol);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            this.waitForConnection(connection, timeout);
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.writeBytes(post);
            out.flush();
            out.close();
            InputStream inStream = connection.getInputStream();
            if (inStream == null) {
                throw new IllegalStateException("Failure getting the Input stream");
            }
            InputStreamReader inStreamReader = new InputStreamReader(inStream);
            BufferedReader bufferedReader = new BufferedReader(inStreamReader);
            StringBuffer data = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                data.append(line);
                data.append("\n");
            }
            response.setResponseCode(connection.getResponseCode());
            connection.disconnect();
            response.setData(data.toString());
        }
        catch (Exception e) {
            response.setError(e);
        }
        return response;
    }

    public synchronized HTTPResponse getResponse(String request, int timeout) {
        HTTPResponse response = new HTTPResponse();
        try {
            String line;
            HttpURLConnection connection = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(request + " Attempting to connect to " + this.host + " on port " + this.port + " with " + this.protocol);
            }
            connection = this.openConnection(request, this.protocol);
            connection.setRequestMethod("GET");
            connection.setDoOutput(false);
            connection.setDoInput(true);
            this.waitForConnection(connection, timeout);
            InputStream inStream = connection.getInputStream();
            if (inStream == null) {
                throw new IllegalStateException("Failure getting the Input stream");
            }
            InputStreamReader inStreamReader = new InputStreamReader(inStream);
            BufferedReader bufferedReader = new BufferedReader(inStreamReader);
            StringBuffer data = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                data.append(line);
                data.append("\n");
            }
            response.setResponseCode(connection.getResponseCode());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RESPONSE=" + response.getResponseCode());
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (connection.getHeaderFieldKey(i) != null) {
                    sb.append(connection.getHeaderFieldKey(i) + " = " + connection.getHeaderField(i) + "\n");
                    ++i;
                }
                logger.fine(sb.toString());
            }
            connection.disconnect();
            response.setData(data.toString());
        }
        catch (Exception e) {
            response.setError(e);
        }
        return response;
    }

    public synchronized HTTPResponse getResponse(AgentCommand cmd) {
        String encoding;
        StringBuffer sb = new StringBuffer(cmd.getCommandData());
        if (!cmd.isFastCgi() && (encoding = this.getEncoding()) != null && !"".equals(encoding)) {
            try {
                encoding = URLEncoder.encode(encoding, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            sb.append("&_BA=");
            sb.append(encoding);
        }
        return this.getResponse(cmd.getLocation() + "?GO=" + sb.toString(), cmd.getTimeout());
    }

    public synchronized HTTPResponse getResponse(AgentCommand[] cmd, int timeout) {
        String encoding;
        if (cmd.length < 1) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer(cmd[0].getLocation());
        sb.append("?GO=");
        sb.append(cmd[0].getCommandData());
        if (!cmd[0].isFastCgi() && (encoding = this.getEncoding()) != null && !"".equals(encoding)) {
            try {
                encoding = URLEncoder.encode(encoding, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            sb.append("&_BA=");
            sb.append(encoding);
        }
        for (int i = 1; i < cmd.length; ++i) {
            sb.append("&GO" + i + "=");
            sb.append(cmd[i].getCommandData());
        }
        return this.getResponse(sb.toString(), timeout);
    }

    private String getEncoding() {
        String encoding = "";
        if (this.user != null) {
            String userPasswd = this.user + ":" + this.password;
            encoding = new BASE64Encoder().encode(userPasswd.getBytes());
        } else {
            encoding = Roles.getIPCAuthentication();
        }
        return encoding;
    }

    private HttpURLConnection openConnection(String request, String protocol) throws ConnectException, IOException {
        URL url = null;
        this.abort();
        try {
            url = new URL(protocol, this.host, this.port, request);
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException(request);
        }
        HttpURLConnection c = null;
        c = (HttpURLConnection)url.openConnection();
        c.setRequestProperty("Authorization", "Basic " + this.getEncoding());
        c.setAllowUserInteraction(false);
        c.setUseCaches(false);
        if (c.getURL().toString().startsWith(HTTPS_PROTOCOL)) {
            HttpsURLConnection sc = (HttpsURLConnection)c;
            try {
                TrustManager[] simpleTM = new TrustManager[]{new SimpleTrustManager()};
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, simpleTM, null);
                sc.setSSLSocketFactory(ctx.getSocketFactory());
                sc.setHostnameVerifier(new SimpleHostnameVerifier(this.host));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalStateException("Security exception" + nsae.toString());
            }
            catch (KeyManagementException kme) {
                throw new IllegalStateException("Security exception" + kme.toString());
            }
        }
        return c;
    }

    public synchronized void abort() {
        if (this.connecting) {
            this.abortConnection = true;
            this.notifyAll();
        }
    }

    private synchronized void connected(HttpURLConnection connection, IOException e) {
        this.connectException = e;
        this.connecting = false;
        this.notifyAll();
    }

    private synchronized void waitForConnection(HttpURLConnection connection, int timeout) throws InterruptedException, IOException {
        this.abortConnection = false;
        this.connectException = null;
        this.connecting = true;
        ConnectThread t = new ConnectThread(connection, timeout);
        t.start();
        while (this.connecting) {
            if (this.abortConnection) {
                this.connecting = false;
                throw new InterruptedException("Connection aborted");
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {}
        }
        this.connecting = false;
        if (this.connectException != null) {
            throw this.connectException;
        }
    }

    public class SimpleHostnameVerifier
    implements HostnameVerifier {
        private String hostname;

        public SimpleHostnameVerifier(String hostname) {
            this.hostname = hostname;
        }

        public boolean verify(String hostname, SSLSession session) {
            return this.hostname.equals(hostname);
        }
    }

    public class SimpleTrustManager
    implements X509TrustManager {
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private class ConnectThread
    extends Thread {
        private IOException ce = null;
        HttpURLConnection connection;
        int timeout;

        ConnectThread(HttpURLConnection connection, int timeout) {
            this.connection = connection;
            this.timeout = timeout > 0 ? timeout : DEFAULT_TIMEOUT;
            this.setName(new String("ConnectThread::") + this.getName());
        }

        public void run() {
            try {
                AbortTimer at = new AbortTimer(this.connection, this.timeout);
                at.start();
                this.connection.connect();
                at.done();
            }
            catch (IOException e) {
                this.ce = e;
            }
            HTTPConnection.this.connected(this.connection, this.ce);
        }
    }

    private class AbortTimer
    extends Thread {
        boolean isDone;
        int seconds;
        HttpURLConnection urlc;

        AbortTimer(HttpURLConnection urlc, int seconds) {
            this.seconds = seconds;
            this.urlc = urlc;
            this.isDone = false;
            this.setName(new String("AbortTimer::") + this.getName() + "::" + seconds);
        }

        public synchronized void done() {
            this.isDone = true;
            this.notify();
        }

        public synchronized void run() {
            try {
                if (this.isDone) {
                    this.notifyAll();
                    return;
                }
                this.wait(this.seconds * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isDone) {
                logger.fine("Aborted connection after " + this.seconds + " seconds.");
                HTTPConnection.this.abort();
                this.urlc.disconnect();
            }
        }
    }
}

