<%@ page language="java"%>
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>
<%@taglib uri="/WEB-INF/lib/sa.tld" prefix="sa"%>

<jato:useViewBean className="com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.revision.RABackoutViewBean">

<%
  String isPrivilegedUser = (String)session.getAttribute("storade.privilegedRole");
  if (isPrivilegedUser == null) isPrivilegedUser = "false";

  String isReserved = (String)session.getAttribute("storade.systemReserved");
  if (isReserved == null) isReserved = "false";

  String deviceTypes = (String)session.getAttribute("deviceTypes");
  if (deviceTypes == null) deviceTypes = "";
%>

<%
  String warningMessageBackout = (String)session.getAttribute("warningMessageBackout");
  if (warningMessageBackout == null) warningMessageBackout = "Generate Patch Backout Report?";

  String warningMessageClear = (String)session.getAttribute("warningMessageClear");
  if (warningMessageClear == null) warningMessageClear = "Clear Patch Report?";
%>

<script language="javascript">

function confirmRevBackout() {
  return confirm("<%=warningMessageBackout%>");
}

function confirmClearReport() {
  return confirm("<%=warningMessageClear%>");
}

// Check if the checkbox is for a row for an array
function isArray(itemSelected) {
  var devices     = new Array(<%=deviceTypes%>);
  var index       = "";
  var prefix      = "RABackout.RevisionAnalysisBackoutReportTable.SelectionRadiobutton";
  var prefixIndex = itemSelected.indexOf(prefix);
  if (prefixIndex != -1) {
    index = itemSelected.substr(i+prefix.length-2);
  }
  for (i = 0; i < devices.length; i++) {
    if (index == i+1 && devices[i] == "array") return true;
  }
  return false;
}

// This function will toggle the disabled state of action buttons
// depending on single or multiple selections.
function toggleDisabledState() {
   // do we have the role to activate the menu?
   // Action button and menu names.
   var viewVolButton = "RABackout.viewAffectedVolumes";

   // Element name (prefix) of selection checkbox/radiobutton.
   var elementName = "RABackout.RevisionAnalysisBackoutReportTable.Selection";

   // Document form.
   var form = document.form;

   // Flag indicating to disable action button and menu options.
   var disabled = true;
   var itemSelected = "-";

   var numChecked = 0;
   // Set flags according to single or multiple selections.
   for (i = 0; i < form.elements.length; i++) {
     var e = form.elements[i];

      if (e.name != null && e.name.indexOf(elementName) != -1) {
        if (e.type == "radio" && e.checked) {
          disabled = false;
          numChecked++;
          itemSelected = e.id; // use id instead of name for radio
        }
      }
   }
   if (numChecked > 1) {
     ccSetButtonDisabled(viewVolButton, "form", true);
   } else {
     ccSetButtonDisabled(viewVolButton, "form", disabled);
     if (!(isArray(itemSelected))) {
       ccSetButtonDisabled(viewVolButton, "form", true);
     }
   }

   // do we have the role to apply a patch
   if (!('true' == '<%=isPrivilegedUser%>')) {
     ccSetButtonDisabled(applyButton, "form", true);
   }

   // the system is reserved, cannot apply a patch
   if ('true' == '<%=isReserved%>') {
     ccSetButtonDisabled(applyButton, "form", true);
   }

}

</script>

<sa:primarymasthead name="Masthead" showDefaultPageTitle="withBarOnly"/>
<jato:form name="form" method="post">

<cc:spacer name="spacer" height="20" newline="true"/>

<div class="ConMgn">
<!-- Page Inline Help -->
<table>
 <tr>
  <td>
   <cc:helpinline type="page">
    <cc:text name="StaticText" bundleID="appBundle" defaultValue="ra.help.text.backout" />
   </cc:helpinline>
  </td>
 </tr>
</table>
</div>

<div class="ConMgn">

<cc:spacer name="spacer" height="15" newline="true"/>

<cc:button name="generateRevAnalysisBackoutReportButton" bundleID="appBundle"
     defaultValue="button.generateRevAnalysisBackoutReport"
     title="button.generateRevAnalysisBackoutReport"
     type="primary"
     dynamic="true" 
     onClick="javascript: return confirmRevBackout();" />

<jato:content name="ClearButtonSection">

  <cc:button name="clearRevAnalysisBackoutReportButton" bundleID="appBundle"
      defaultValue="button.clearRevAnalysisBackoutReport"
      title="button.clearRevAnalysisBackoutReport"
      type="primary"
      dynamic="true" 
      onClick="javascript: return confirmClearReport();" />

</jato:content>

</div>

<cc:spacer name="spacer" height="15" newline="true"/>

<jato:content name="RevisionAnalysisReportSection">

  <div class="ConMgn">
  <cc:text name="ReportText" bundleID="appBundle" defaultValue="assets.revision.backout.report"/>
  </div>

  <cc:spacer name="spacer" height="15" newline="true"/>

  <cc:actiontable
      name="RevisionAnalysisBackoutReportTable"
      bundleID="appBundle"
      title="assets.revision.backout.table.title"
      summary="assets.revision.backout.table.summary"
      empty="assets.revision.backout.table.empty"
      showAdvancedSortingIcon="false"
      showLowerActions="true"
      showPaginationControls="true"
      showPaginationIcon="true"
      showSelectionIcons="false"
      selectionType="single"
      selectionJavascript="toggleDisabledState()"
      page="1" />

</jato:content>

<jato:content name="noRevisionAnalysisReportSection">

  <div class="ConMgn">
  <cc:text name="NoReportText" bundleID="appBundle" defaultValue="assets.revision.backout.noreport"/>
  </div>

</jato:content>



</jato:form>
</jato:useViewBean>


