package Provider::NSCC_Email;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_017 $ 
#  $Id: NSCC_Email.pm,v 1.11 2005/05/17 17:19:05 mckenney Exp $

use PDM;
use PDM::ConfigFile;
use SAF;
use Carp;
use Message;
use Util;
use Mail;
use System;
use Util::Http;
use strict;

use base 'Provider';
sub revision {'$Revision: 1.11 $'}

sub description {'Email'}
sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::NSCC_Email');
  return $p;
}

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $info);
  my($renv, $dev, $host,$notifs, $address);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('nscc_email');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    $renv->{'pro.nscc_email.active'}  = $q->{active}? "Y":"N";
    $renv->{'pro.nscc_email.encrypt'} = $q->{encrypt}? "Y":"N";
    $renv->{'pro.nscc_email.timeout'} = $q->{to};

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->{conf_upd});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();;

  if ($renv->{'pro.nscc_email.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }
  $address= $renv->{'pro.nscc_email.address'};
  $to     = $renv->{'pro.nscc_email.timeout'} || 90;

  my $add = $renv->{'pro.nscc_email.address'} || "nscc_transport\@sun.com";
  my $enc = "checked" if ($renv->{'pro.nscc_email.encrypt'} eq "Y");

  my $scr = Html::Screen->new();
  $scr->add(" $err <form  method=get> <input type=hidden name=GO value=GUI::Providers::display>
        <input type=hidden name=option value=$q->{option}>");

  $scr->table({ title => $L->{label}},
    [
    [ f => $G->{active},  "<input type=checkbox name=active $active> $info" ],
    [ f => $L->{encrypt}, "<input type=checkbox name=encrypt $enc>" ],
    [ f => $L->{address}, $add ],
    ]);

   if (!$deny) {
     $scr->button2([
       [  l => 'ACTION_update', $G->{submit_update} ]
       ]);
   }
   $scr->add("</form>");
   return $scr->out();
}

  
sub RUN {
  my($pro, $idList) = @_;
  my($f, $l, $transmit);
  $DB::single = 1;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $mailer = $renv->{mailer} || "/usr/bin/mail";
  my($acronym) = "Storage_ADE";
  my $secure = $renv->{"pro.nscc_email.encrypt"}; # Y/N
  my $L = Labels->read('Provider')->section('netconnect');


  if ($renv->{'pro.nscc_email.active'} ne "Y") {
     Debug->print2("  $L->{not_active}");
     return;
  }

  my $address = $renv->{'pro.nscc_email.address'} || "nscc_transport\@sun.com";

  $address =~ s/\@/_secure@/ if ($secure eq "Y");

  #$address = "nsccencrypt\@nscc-test";  # REMOVE THIS

  my($post) = "";
  my(%options, $old);
  my($allresp);
  my $make_key = System->get_home() . "/sbin/make_key";
  my $key = `$make_key`; chop($key);

  my($newerr) = 0;
  $allresp = "";

  my $data;
  my $cnt =0;
  my $edocs     = PDM->getMessagesFromList($idList);
  my $hostid = System->hostid();
  my $max    = $renv->{max_email_size} || 0.5;
  my $size ;
  my $total = @$edocs;
  my $sentcnt = 0;
  foreach my $ed (@$edocs) {
     #
     # SKIP DS EVENTS IF INSIDE A RACK
     my $ev = $ed->instances(0); 
     # next if ($ev && $ev->value("MgmtLevel") eq "DS" && $renv->{solution} ne "N" );    

     my $toc = $ed->toC();
     
     if (($cnt >0 ) && ($cnt > 50 || $size + length($toc) > $max * 1000000)) {

         if ($secure eq "Y") {
           $data = &encrypt($data);
         }
         Mail->mail($address, $acronym, "secureTOCB: [$hostid]", $data);
         Debug->print2("EmailProvider: sending $cnt events. Sent $sentcnt of $total events.");
         $cnt=0; $data= ""; $size= 0;
     }
     $sentcnt++;
     $cnt++;
     $data .= $toc;
     $size += length($toc);
  }
  if (($secure eq "Y") && $cnt) {
    $data = &encrypt($data);
  }
  Mail->mail($address, $acronym, "secureTOCB: [$hostid]", $data);
  Debug->print2("EmailProvider: sending $cnt events. Sent $sentcnt of $total events.");
}


sub encrypt {
  my($data) = @_;

  my ($l, $out);

  my $F = "/tmp/sa_enc_$$";
  open(O, ">$F");
  print O $data;
  close(O);

  system(System->get_home() . "/sbin/bcrypt $F");
  system("/usr/bin/uuencode $F.bfe message.toc > $F.uu");

  open(O, "$F.uu");
  while ($l = <O>) {
    $out .= $l;
  }
  system("/bin/rm $F*");
  return $out;

}

1;

