package NWS::D2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_017 $ 
#  $Id: D2.pm,v 1.6 2005/01/10 18:27:57 mckenney Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.6 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j);
  my($CTRL);


  # From "./NWS/SCH_Storage.pm"
  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		  => "SUN.D2." . $rep->get('id.wwn')],
                    [SystemName           => "SUN.D2." . $rep->get('id.name')],
		    [OtherIdentifyingInfo => $rep->get('id.name')],
		    [SysRevision          => $rep->get('info.Revision')],
		    [SerialNo             => $rep->get('midplane.serial')],
                    [FruDiskDriveCount    => $rep->get('slot.total') ],
                    [FruPowerCount        => $rep->get('encConfig.Number_of_Power_Supplies') ],
                    [Fan0Status           => $rep->get('fan.0.status') ],
                    [Fan1Status           => $rep->get('fan.1.status') ],
                    [Caption              => "D2"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 				=> "SUN.D2." . $rep->get('id.wwn')],
                  [Manufacturer 		=> 'SUN'],
                  [Model 			=> 'D2'],
                  [Name  			=> "SUN.D2." . $rep->get('id.wwn')],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);


  $dd = $class->newMidplane($rep,"midplane");
  if ($dd) {
    $a = CIM::Instance->new('CIM_Container', [
                 [GroupComponent  => $p2],
                 [PartComponent => $dd->[1]],
                 [LocationWithinContainer => "midplane"],
                 ]);
 
    push (@pil, @$dd);
    push (@pil, $a);
  }




  for ($j = 0; $j < 2 ; $j++) {
      next if (!$rep->get("esm.$j.serial") );


      $dd = $class->newController($rep,"esm.$j");
      next if (!$dd);
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "esm.$j"],
                   ]);
      push (@pil, @$dd);
      push (@pil, $a);

  }
  my($x, $slot);
  for ($slot=0; $slot <= 20; $slot++) {

    for ($j=0; $j < $rep->get("slot.$slot.total") ; $j++) {
      if ($rep->{"slot.$slot.$j.serial"}) {
        $dd = $class->newDiskDrive($rep,"slot.$slot.$j");
        $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "slot.$slot.$j"],
                   ]);

        push (@pil, @$dd);
        push (@pil, $a);
      }
    }
  }

  for ($x=0; $x <= 10; $x++) {
     if ($rep->{"power.$x.status"}) {
       $dd = $class->newPowerUnit($rep,"power.$x");
       $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "power.$x"],
                   ]);

       push (@pil, @$dd);
       push (@pil, $a);
     }
     if ($rep->{"fan.$x.status"}) {
       $dd = $class->newFan($rep,"fan.$x");
       $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "fan.$x"],
                   ]);

       push (@pil, @$dd);
       push (@pil, $a);
     }
  }

  return Ilist->new(\@pil);

}




sub newController {

  my($class, $rep, $cd) = @_;
  my(@il, $a1, $c1, $p1);

  my($serial_no) = $rep->get("$cd.serial");
  $serial_no .= ".ctr";
 
   $p1 = CIM::Instance->new('NWS_Controller', [
                [SystemName     => $cd],
		[DeviceID       => "SUN.D2." . $serial_no],
                [Name           => $serial_no],
                [StatusInfo     => "OK"],
                [Status         => "OK"],

                 ]);

  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => ""],
               [Tag                 => "SUN.D2." . $serial_no],
               [SerialNumber        => $serial_no],
               [WWN                 => $rep->get('id.wwn') ],
               [Manufacturer        => ""],
               [Model               => $rep->get("$cd.product")],
               [Version             => $rep->get("$cd.date")],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  return Ilist->new(\@il);
}

sub newMidplane {

  my($class, $rep, $cd) = @_;
  my(@il, $a1, $c1, $p1);

  my($serial_no) = $rep->get("$cd.serial");
  $serial_no .= ".mpn";
 
   $p1 = CIM::Instance->new('NWS_Midplane', [
                [SystemName     => $cd],
		[DeviceID       => "SUN.D2." . $serial_no],
                [Name           => $serial_no],
                [StatusInfo     => "OK"],
                [Status         => "OK"],

                 ]);

  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => ""],
               [Tag                 => "SUN.D2." . $serial_no],
               [SerialNumber        => $serial_no],
               [WWN                 => $rep->get('id.wwn') ],
               [Manufacturer        => ""],
               [Model               => ""],
               [Version             => $rep->get("$cd.date")],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  return Ilist->new(\@il);
}

sub newDiskDrive {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my($status) = $rep->get("${cd}.status");

  my $serial_no = $rep->{"$cd.vendor"} . "." . 
                  $rep->{"$cd.model"} . "." .
                  $rep->{"$cd.serial"};

  my($map)   = PDM->getDeviceStateMap("d2.availability");
  my($state) = $map->get("disk.status." . $rep->get("$cd.status"));
  my $wwn = $rep->get("id.wwn") . "." . $cd;

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName         => $rep->{"$cd.vendor"} . " DiskDrive"],
                [DeviceID           => "SUN.D2." . $serial_no ],
                [Name               => "SUN.D2." . $serial_no ],
                [Wwn                => $rep->get("$cd.dev") ],
                [StatusInfo         => $status],
                [Status             => $state],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable              => "Yes"],
                [Replaceable            => ""],
                [Tag                    => "SUN.D2." . $serial_no ],
                [Name                   => "SUN.D2." . $serial_no ],

                [Manufacturer           => $rep->{"$cd.vendor"}  ],
                [Model                  => $rep->{"$cd.model"}   ],
                [PartNumber             => $rep->{"$cd.serial"}  ],
                [SerialNumber           => $rep->{"$cd.serial"}  ],
                [Version                => $rep->{"$cd.revision"}  ],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent  => $p1],
                    ]);
  push(@il, $a1);

  return Ilist->new(\@il);

}

sub newPowerUnit {
  my($class, $rep, $cd) = @_;
  my(@il, $p1 ,$c1, $a1);
  my $serial_no = $rep->get('id.wwn') . "-" . $cd;
  
  $p1 = CIM::Instance->new('NWS_PowerUnit', [
               [SystemName   => "D2-PCU"],
               [DeviceID     => "SUN.D2." .$serial_no],
               [Name         => "SUN.D2." .$serial_no],
	       [StatusInfo   => $rep->{"$cd.status"}],
               [Status       => $rep->{"$cd.status"} ],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
               [Removable       => "Yes"],
               [Tag             => "SUN.D2." .$serial_no],
               [Name            => "SUN.D2." .$serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
               [Antecedent      => $c1],
               [Dependent       => $p1],
                    ]);

  push(@il,$a1);

  return Ilist->new(\@il);
}


sub newFan {
  my($class, $rep, $cd) = @_;
  my(@il, $p1 ,$c1, $a1);
  my $serial_no = $rep->get('id.wwn') . "-" . $cd;

  $p1 = CIM::Instance->new('NWS_Fru', [
               [SystemName        => "D2-FAN"     ],
               [CreationClassName => "Fan"        ],
	       [Type           => "D2.Fan"     ],
               [DeviceID          => "SUN.D2." . $serial_no   ],
               [Name              => "SUN.D2." .$serial_no   ],
               [Status            => $rep->{"$cd.status"} ],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
               [Removable       => "Yes"],
               [Tag             => "SUN.D2." .$serial_no],
               [Name            => "SUN.D2." .$serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
               [Antecedent      => $c1],
               [Dependent       => $p1],
                    ]);

  push(@il,$a1);

  return Ilist->new(\@il);
}







1;
