package Map;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_017 $ 
#  $Id: Map.pm,v 1.3 2005/03/09 19:53:03 mckenney Exp $
use vars qw ($MAP);


sub revision {'$Revision: 1.3 $'}

sub new {
  my($class, $map) = @_;

  my($arg) = {};
  $arg->{map} = $map;
  bless($arg, "Map");
  return $arg;
}

sub getDeviceStateMap {
  my($class, $section) = @_;

  my($l, %MAP);
  return $MAP->section($section) if ($MAP && $section);

  my($F) = System->get_home() . "/System/Map";
  opendir(O, $F);
  my @L = readdir(O); closedir(O);
  foreach my $d (@L) {
     next if ($d !~ /.map$/);
     open(O, "$F/$d");
     my $ix = index($d, ".");
     my $fname = substr($d, 0, $ix);
     my($sec) = "";
     while ($l = <O>) {
        chop($l);
        $l = Util->rtrim($l);
        next if (substr($l,0,1) eq "#");
        if (substr($l,0,1) eq "[") {
           my $v = substr($l,1,-1);
           $ix = index($v, ".");
           $v = substr($v,$ix+1) if ($ix > 0);
           $sec = "$fname.$v";
        } elsif (index($l, "=>") > 0) {
           my(@a) = split(/\s*[\>\=]+\s*/, $l);   #  val1 => val2 = W|WY|E|EN
           $MAP{$sec}{"$a[1],$a[0]~"} = &sev_ac($a[2]);

        } else {
           my(@a) = split(/\s*\=\s*/, $l);        # val1 = 0|1 = W|WY|E|EN
           next if ($#a < 1);
           my $x = &sev_ac($a[2]);
           $MAP{$sec}{$a[0]} = [$a[1], $x->[0], $x->[1]];  # available[0/1], sev, actionable
        }
     }
     close(O);
  }
  $MAP = Map->new(\%MAP);
  if ($section) {
    return $MAP->section($section);
  } else {
    return $MAP;
  }
}

# gbic.status.Not Installed = 0

sub sev_ac {
  my($l) = @_;
  my ($sev, $ac);
  my $l0 = substr($l,0,1) ;
  $sev = -1;
  if ($l0 eq "W") {
    $sev = 1;
    $ac = "N";
  } elsif ($l0 eq "E") {  # error
    $sev = 2;
    $ac = "Y";
  } elsif ($l0 eq "X") {  # NO EVENT
    $sev = -9;
    $ac = "N";
  } elsif ($l0 eq "I") {  # info
    $sev = 0;
    $ac = "N";
  }
  if (length($l) > 1) {
     $ac = substr($l,1);
  }
  my @L = ( $sev, $ac);
  return \@L;
}



sub section {
  my($map, $section)  = @_;
  
  my($s) = $map->{map}{$section};
  $s = {} if (!$s);

  bless($s, 'Map');
  return $s;
}

sub get {
  my($map, $val) = @_;

  if (defined($map->{$val}) ) {
     return $map->{$val}[0];
  } else {
     return "X";
  }
}

#
# [ available (0/1) , severity (0,1,2), actionable (Y/N) ]
#
sub get2 {
  my($map, $val) = @_;

  if (defined($map->{$val}) ) {
     return $map->{$val};

  } else {
     return ["X", -1, undef] ;  # cannot find it
  }
}

# my ($oavail,$navail, $sev, $act) = 
#                       $map->transition("$map_id.$s2", "$map_id.$s1", $orep, $rep);
# $act may be blank
#
sub transition {  
  my($map, $old, $new, $orep, $rep) = @_;

  $old = lc($old) if ($map->{LOWERCASE});
  $new = lc($new) if ($map->{LOWERCASE});
  my $oav = $map->get2($old);
  my $av  = $map->get2($new);

  if (exists($map->{"$new,$old~"}) ) {
     my $s = $map->{"$new,$old~"};
     return ($oav->[0], $av->[0], $s->[0], $s->[1]);
  }
  if ($rep eq $orep || !$orep || (ref($orep) eq "HASH" && (keys %$orep) == 0)) {
    if (exists($map->{"$new,START~"})) {
       my $s = $map->{"$new,START~"};
       return ($oav->[0], $av->[0], $s->[0], $s->[1]);
    }
  }
  return ($oav->[0], $av->[0], $av->[1], $av->[2]);
}
  

1;
