package Health::HBAStorage;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_017 $ 
#  $Id: HBAStorage.pm,v 1.11 2005/04/20 17:23:32 sbrooks Exp $


use base 'Health';
use NWS::HBAStorage;
use Ilist;
use Message;
use Catalog;
use Report;
use Events;
use strict;
use Debug;
sub revision {'$Revision: 1.11 $'}


sub all_logic {
  my($hm, $report) = @_;
  my($orep, $comp);
  $DB::single = 1;
  my $rep      = $report->content;
  my $oreport  = PDM->getOldReport($report->fileKey);

  CIM->version("1.1");

  my $type     = $report->id('category');
  my $Config   = System->get_Config();
  my $freq     = System->get_renv()->{audit_freq} || 7;
  my $orep     = $oreport->content() if ($oreport);

  my (@OLD_DEV, @NEW_DEV, %OLD_WWN, %NEW_WWN, $s);

#
# SAVE AN ARRAY OR REPORTS FOR NEW AND OLD REPORTS
# SAVE A HASH OF DEVICE WWN.
#
  foreach my $el (keys %$rep) {
      if ($el =~ /^device\.(\d+)\.(.+)/) {
        $NEW_DEV[$1]{$2} = $rep->{$el}
      }
      if ($el =~ /^device\.(\d+)\.id\.key/) {
         my $ix = $1;
         my $wwn = $rep->{$el};
         $NEW_WWN{$wwn} = $ix;
      }
  }

  foreach my $el (keys %$orep) {
      if ($el =~ /^device\.(\d+)\.(.+)/) {
        $OLD_DEV[$1]{$2} = $rep->{$el}
      }
      if ($el =~ /^device\.(\d+)\.id\.key/) {
         my $ix = $1;
         my $wwn = $rep->{$el};
         $OLD_WWN{$wwn} = $ix;
      }
  }

  for ($s=0; $s <= $#OLD_DEV; $s++) {
    my $sw  = $OLD_DEV[$s];
    my $wwn = $sw->{'id.key'};
    my $status = exists $NEW_WWN{$wwn} ? "OK" : "CC";
    my $report = Report->new($hm->id($sw), $OLD_DEV[$s], [], $status);
    my $info = " connected to HBA $sw->{'hba.adapter_Name'}(WWN=$sw->{'hba.PortWWN'})";
    $hm->connectionEvent($wwn, $report, {method => 1, info => $info, threshold_severity => 0 });
  }
  for ($s=0; $s <= $#NEW_DEV; $s++) {
    my $sw = $NEW_DEV[$s];
    my $wwn = $sw->{'id.key'};

    #next if ($Config->deviceByWWN($sw->{'fcport.0.PortWWN'}));

    my $report = Report->new($hm->id($sw), $NEW_DEV[$s], [], "OK");

    if (!exists($OLD_WWN{$wwn})) {  # added a device (Discovery)
        $hm->discoveryEvent($report, "NWS::HBAStorage", 0);

    } else {
       my ($audit);
       if (($audit=$hm->auditTime($wwn)) eq "YES") {
         $hm->discoveryEvent($report, "NWS::HBAStorage", $audit);
       }
       # audit and changes in port WWN/revision/PortType
       my $old_sw = $OLD_DEV[$OLD_WWN{$wwn}];
       next if (!$old_sw);

       # check that the model/revision of each port is the same
    }
  }
}

sub id {
  my($hm, $sw) = @_;

  my $name  = $sw->{'id.name'} || $sw->{'id.key'};

  my $wwn                 = $sw->{'id.key'};
  my $ip                  = $sw->{'hba.path'};

  $sw->{'id.wwn'}         = $wwn;
  $sw->{'id.device_type'} = "hbastorage";
  $sw->{'id.name'}        = $name;
  $sw->{'id.path'}        = $sw->{'hba.path'};

  return {
              deviceName =>  $wwn,
              name       =>  $name,
              category   => "hbastorage",
              display    => "$name($ip)",
          };
}


1;
