package Health::9900;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_017 $ 
#  $Id: 9900.pm,v 1.3 2005/04/20 17:23:30 sbrooks Exp $


use base 'Health';
use NWS::9900;
use Ilist;
use Message;
use Catalog;
use Report;
use Events;
use strict;
use Debug;
sub revision {'$Revision: 1.3 $'}


sub all_logic {
  my($hm, $report) = @_;
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $comp);
  $DB::single = 1;
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my $wwn      = $rep->{'id.device_key'};

  my($log)     = $report->log();
  my($id)      = $report->id("display");
  CIM->version("1.1");
  my $type     = $report->id('category');
  my $shortid  = $report->name();

  return if ( $hm->connectionEvent($wwn, $report, {method => 2, threshold_severity => 1} )); 
  my $freq  = System->get_renv()->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  
     my($etype) = $audit eq "YES" ? "$type.AuditEvent" : "$type.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);

     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => "$type:$wwn"   ],
                  [ TargetName  => $id    ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => "$title $type called $id"],
                  [ Data        => $hm->serial($rep) ],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::9900->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);
#

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     PDM->saveMessage($ed);
  }
  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);
  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame', # frame key 
                       Tag               => $wwn,
                       CreationClassName => 'CIM_PhysicalFrame' ]);

  foreach my $el (keys %$rep) {
      if ($el =~ /^controller\.(.*)/) {
         my $topic = $1;
         Grid->setCode("$type.AlarmEvent.controller.$topic");
         $hm->mapValueChangeEvent($report, $orep, uc($type), "controller",$topic, 
                        $id, $id, $wwn, "controller.$topic", {use_map_id => 1});

      } elsif ($el =~ /^disk\.(.*)/) {
         my $topic = $1;
         Grid->setCode("$type.AlarmEvent.disk.$topic");
         $hm->mapValueChangeEvent($report, $orep, uc($type), "disk",$topic, 
                        $id, $id, $wwn, "disk.$topic", {use_map_id => 1} );
      }
  }

  my $old_version = $orep->get("raid.DKCMainVersion");
  my $new_version = $rep->get("raid.DKCMainVersion");

  if ($old_version ne $new_version) {
     Grid->setCode("$type.AlarmEvent.contr_version");
     $hm->valueChangeEvent("controller", "", $report, $wwn, 
          "Controller version on $type $id changed from '$old_version' to '$new_version'", 
          1, "ctrl_version");
  }

}



1;
