package Agent::SWITCH;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_017 $ 
#  $Id: SWITCH.pm,v 1.3 2005/03/04 21:51:43 mckenney Exp $

use strict;
use Agent::SWITCH_Parent;
use base 'Agent::SWITCH_Parent';

sub isSelectable {"Sun Switch"}
sub revision {'$Revision: 1.3 $'}

# Report::CAT_SWITCH
# implements INSTRUMENTATION, CONFLICTS, MAX_THREADS, getWWN, REPORT, FRUS, 

sub HEALTH {
  my($agent, $new_rep) = @_;
  require Health::Switch;
  Health::Switch->all_logic($new_rep);
}


use vars qw( $ERR $SANBOX_PORT);

$SANBOX_PORT = 5002;

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SWITCH');
  return $self;
}


sub getPortKey {
  my($class, $wwn, $port) = @_;
  return undef if (!$wwn);
  return "$wwn.port.$port";
}

sub CONFLICTS {
  return System->get_se_conflict();
}

sub MAX_THREADS {
  return 1;
}



sub getVersion {
  my($class, $ip, $TO) = @_;
  my %V;
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;

  my $DIR = System->get_home() . "/bin";
  my($err0,$version) = Util->run_command("$DIR/sanbox version -port $swport $ip 2>&1", "sanbox_version.txt", $TO);

  if ("@$version" =~ /failed exch/ || "@$version" =~ /bad hostname:/ ||
      $version->[0] =~ /Error:/) {
     $ERR = "@$version";
     return undef;
  } else {
     foreach my $l (@$version) {
       my($key, $val) = split(/:\s*/, $l);
       $V{$key} = $val;
     }
     return \%V;
  }
}



sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, %info);
  my($connect_err, %C);
  my($chassis, $port,  $loop, $config, $network, $toggle);
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;
  my($error, $wwn, $report);
  $DB::single = 1;

  return Report->readTest($device) if (System->get_testMode());
  
  my($ip)    = $device->{ip};
  my($s_ip) = $ip;
  if ($device->{primary}) {
     $s_ip = "-f $device->{fc} $device->{primary}";
  }
     
  my(@counts, @stats, $stat, $x);
  my($DIR) = System->get_home() . "/bin";
  my($TO) = $renv->{'timeout.snmp'};

  my($err0,$version) = Util->run_command("$DIR/sanbox version -port $swport $s_ip 2>&1", "sanbox_version.txt", $TO);
  if ($err0) {
    Debug->err(SANBOX => "Cannot run $DIR/sanbox $ip:$err0");
    $report->{'rc.error'} = "Sanbox error: $err0";
    return $report;
  }

  if ("@$version" =~ /failed exch/ || "@$version" =~ /bad hostname:/ ||
      $version->[0] =~ /Error:/) {
     $connect_err = " @$version";
     $report->{'rc.error'} = $connect_err;
     return $report;
  }
  Timelapse->startDev( $device);
  ($err0,$chassis) = 
     Util->run_command("$DIR/sanbox chassis_status -port $swport $s_ip", "sanbox_chassis.txt", $TO);
  my($err2,$counts) = Util->run_command("$DIR/sanbox port_counts -port $swport $s_ip all", "sanbox_counts.txt", $TO, {cache => 0});
  my($err3,$state) = Util->run_command("$DIR/sanbox port_state -port $swport $s_ip all", "sanbox_state.txt", $TO);

  ($error, $wwn, $report) = $agent->parse2($version, $counts, $state, $chassis, $DIR, $s_ip, $TO);

  if (index("|$renv->{categories}|", "|san|") >= 0) {
     $report->{"FC_COUNTERS"} = $agent->FCfromDevice($device);
  }


  $report->{'id.name'} = $device->{name};
  $report->{"rc.error"} = $error;
  $report->{"rc.key"}   = $wwn;
  Timelapse->stopDev( $device);
  return $report;
}

sub getPortCount {
  my($class, $ip, $host, $TO) = @_;
  my $rc;
  $ERR = undef;
  if ($host) {
      $rc = Util::Http->getCommand($host, 
                "Agent::SWITCH::WWN&ip=$ip&HTTP=1&command=chassis_status", $TO);
      if (substr($rc,0,3) eq "ERR") {
         $ERR = $rc;
         return undef;
      } else {
         return $rc;
      }
  } else {
      return get_WWN({ip => $ip, command => "chassis_status"});
  }
}

#
# get WWN of a switch using ip or proxy.
#
sub getWWN {
  my($class, $ip, $host, $TO) = @_;
  my $rc;
  $ERR = undef;
  if ($host) {
      $rc = Util::Http->getCommand($host, "Agent::SWITCH::WWN&ip=$ip&HTTP=1", $TO);
      if ($rc =~ /ERR/) {
         $ERR = $rc;
         return undef;
      } else {
         return substr($rc,4);
      }
  } else {
      return get_WWN({ip => $ip});
  }
}

sub get_WWN {
  my($q) = @_;
  my $ip = $q->{ip};
  my $wwn;
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;
  my $command = $q->{command} || "version";
  my $DIR = System->get_home() . "/bin";
  my($err1,$info) = Util->run_command("$DIR/sanbox $command -port $swport $ip ", "sanbox_status.txt", 20);
  if ($command eq "chassis_status") {
     if ("@$info" =~ /Ports:\s+(\d+)/) {
        $wwn = $1;
     }
  } elsif ("@$info" =~ /WWN:\s+(\w+)/) {
        $wwn = $1;
  }
  if ($q->{HTTP}) {
    if ($wwn) {
      print "\nOK $wwn";
    } else {
      print "\nERR $err1";
    }
  } else {
    return $wwn;
  }
}

#Parity errors detected:              0
#Out of regular frame buffers errors: 0
#Out of small frame buffers errors:   0


sub getASIC {
  my($class, $DIR, $s_ip, $TO, $V) = @_;
  my($err, $x, $count);
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;

  my($err1,$info) = Util->run_command("$DIR/sanbox chassis_counters -port $swport $s_ip all", "sanbox_status.txt", $TO);
  my $type;
  foreach my $l (@$info) {
     if ($l =~ /S4s on board:/) {
        $V->{"ASIC.count"} = substr($l,14) + 0;

     } elsif ($l =~ /Parity errors detected:\s+(\d+)/) {
        $V->{"ASIC.parityErrors"} = 1;

     } elsif ($l =~ /Out of regular frame buffers errors:\s+(\d+)/) {
        $V->{"ASIC.OutOfRegularFrame"} = 1;

     } elsif ($l =~ /Out of small frame buffers errors:\s+(\d+)/) {
        $V->{"ASIC.OutOfSmallFrame"} = 1;

     } elsif ($l =~ /^Interrupt Handler errors/) {
        my $l1 = substr($l,26);
        my @L = split(/\s+/, Util->ltrim($l1));
        
        for ($x=0; $x <= $#L; $x++) {
           $V->{"ASIC." . ($x+1) . ".InterruptError"} = $L[$x];
        }
     } elsif ($l =~ /^COF Parity Errors/) {
        my $l1 = substr($l,26);
        my @L = split(/\s+/, Util->ltrim($l1));
        
        for ($x=0; $x <= $#L; $x++) {
           $V->{"ASIC." . ($x+1) . ".COF_Parity"} = $L[$x];
        }
     } elsif ($l =~ /^COF CRC Error/) {
        my $l1 = substr($l,26);
        my @L = split(/\s+/, Util->ltrim($l1));
        
        for ($x=0; $x <= $#L; $x++) {
           $V->{"ASIC." . ($x+1) . ".COF_CRC"} = $L[$x];
        }
     } elsif ($l =~ /^Frame bus control/) {
        $type = "FrameBusControl";

     } elsif ($l =~ /^Internal Parity Er/) {
        $type = "InternalParity";

     } elsif ($l =~ /^ASIC\s+(\d+)\s+Port (\d+): (\d+)/) {
        my $asic = $1; my $port = $2; my $cnt = $3;
        $V->{"ASIC." . ($asic+1) . ".port.$port.$type"} = $cnt
     }
  }
}
      


#
# if one of the zone-types fails, the whole zone report is skipped;
#
sub getZones {
  my($class, $DIR, $s_ip, $TO, $V) = @_;
  my($err);
  my $totzones;
  my $V1 = {};
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;

  foreach my $type ('hd','ns','sl') {
     my($err1, $info) = Util->run_command("$DIR/sanbox get_zone -port $swport $s_ip $type all", "sanbox_status.txt", $TO);
     if ("@$info" =~ /Error:/) {
         $V->{"error.get_zone"} = "@$info, $s_ip, get_zone, $type";
         return "@$info, $s_ip, get_zone, $type";
     }
     my $z = -1;
     my $enabled;
     foreach my $l (@$info) {
        if ($l =~ /Zone:\s+(\d+), Enabled: yes/) {
           $z = $1;
           $totzones++ if ($z < 100);
            
        } elsif ($l =~ /Port: (\d+)/) {
           my $p = $1;
           if ($z < 100) {
             my $vz = " " . $V1->{"zone.$type.$z.members"};
             my $po = $1;
             if (index($vz, " $po ") < 0) {
               $V1->{"zone.$type.$z.members"} .= "$po ";
             }
           }
        }
     }
  }
  $V->{"zone.total"} = $totzones;
  foreach my $el (keys %$V1) {
    $V->{$el} = $V1->{$el};
  }
  return undef;

}

  
sub getDevStatus {
  my($class, $device) = @_;

  my($ip)    = $device->{ip};
  my($s_ip) = $ip;
  if ($device->{primary}) {
     $s_ip = "-f $device->{fc} $device->{primary}";
  }
  my $V = {};
  my $D = System->get_home() . "/bin";
  $class->getStatus($D, $s_ip, 10, $V);
  $class->getLinks($s_ip, 10, $V);
  return $V;

}

#  Agent::SWICH->getLinks("1.1.1.1", 10, $R);

sub getLinks {
  my($class, $s_ip, $TO, $V) = @_;
  my($ch_text, $my_chassis_id);
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;

  my $DIR = System->get_home() . "/bin";
  # get chassis id of this switch
  my($err2,$status1) = Util->run_command("$DIR/sanbox chassis_id -port $swport $s_ip",
                           "sanbox_status.txt", $TO);
  my($x, $l);
  my $chassis = "@$status1";
  $chassis =~ /ChassisID: (\d+)/;
  $my_chassis_id = $1;

  $V->{"id.chassis_id"}  = $my_chassis_id;

  my($err1,$status) = Util->run_command("$DIR/sanbox links -port $swport $s_ip all", 
                      "sanbox_status.txt", $TO);
  my $in = 0;
  my $my_id = 0;
  my $ch_id = -1;
  my ($a, $rest);
  for ($x=0; $x <= $#$status; $x++) {
    $l = $status->[$x];
    chomp($l);
    if ($l =~ /Chassis:/) {
       ($a, $ch_id, $rest) = split(/\s+/, Util->ltrim($l), 3);

    } elsif ($ch_id == $my_chassis_id){
       if ($l =~ /\s+Port:/) {
           my($a, $port, $chassis, $port2, $fc, $wwn) = split(/\s+/, Util->ltrim($l));
           $port = hex("0x" . $port);
           my $link_p = hex("0x" . $port2);
           $V->{"port.$port.link_port"} = $link_p; # hex to decimal
           $V->{"port.$port.link_wwn"}  = sprintf("20%2.2x%s",$link_p-1 , substr($wwn,4)) ;
           $V->{"port.$port.link_fc"}   = $fc;
       }
    }
  }
}



sub getStatus {
  my($class, $DIR, $s_ip, $TO, $V) = @_;
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;

  my($err1,$status) = Util->run_command("$DIR/sanbox port_status -port $swport -a $s_ip all", "sanbox_stat
us.txt", $TO);

  my $in = ""; my($p) = "8";
  my($x, $l);
  my($totzones) = 0;
  for ($x=0; $x <= $#$status; $x++) {
    $l = $status->[$x];
    chomp($l);
    my @b = split(/\s+/, $l);
    if ($l =~ /Port:/) {
       $p      = $b[1]; # sprintf("%3.3d", $b[1]);
       $V->{"port.$p.type"}   = $b[2];
       if ($l =~ /Offline/ || $l =~ /Not-logged-in/) {
         $V->{"port.$p.mode"}   =  "Offline"; 
       } else {
         $V->{"port.$p.mode"}   = "Online";
       }
       if ($status->[$x] =~ /Linked-to: (\w+) .* FC: (\w+)/ ) {
          $V->{"port.$p.link_wwn"} = $1;
          $V->{"port.$p.link_fc"} = $2;
 
       } elsif ($status->[$x+1] =~ /^\s+0x/) {
          my($alpa, $wwn, $wwn2) = split(/\s+/, Util->ltrim($status->[$x+1]));
          $V->{"port.$p.link_wwn"} = $wwn if ($wwn !~ /\</);
       }
    }
  }
  $V->{"version.ports"} = $p;
}



sub parse2 {
  my($agent, $version, $counts, $state, $chassis, 
      $DIR, $s_ip, $TO) = @_;
  my($in, %V, $enabled, $mfs, $fan, $attr, $l, @b);

  foreach $l (@$version) {
    chomp($l);
    @b = split(/\s*:\s*/, $l, 2);

    $V{"version.$b[0]"} = $b[1];
    if ($b[0] eq "WWN" || $b[0] eq "MAC") {
        $V{"id." . lc($b[0]) } = lc($b[1]);
    }
  }

# CHASSIS

  foreach $l (@$chassis) {
    chomp($l);
    if ($l =~ /Power:\s+(.+)/) {
        $V{"chassis.power.status"} = $1;

    } elsif ($l =~ /Temp:\s+(.+)/) {
        $V{"chassis.temp.status"} = $1;

    } elsif ($l =~ /Temp =\s+(.+)/) {
        $V{"chassis.temp.value"} = $1;

    } elsif ($l =~ /Uptime:\s+(.+)/) {
        $V{"chassis.uptime"} = $1;

    } elsif ($l =~ /Fan (\d+):\s+(.+)/) {
        $V{"chassis.fan.$1.status"} = $2;

    }elsif ($l =~ /Error: No response/){
      return ("Chassis status failed for device.", $V{"id.wwn"}, \%V );

    }
     
  }

  $agent->getStatus($DIR, $s_ip, $TO, \%V);
  $agent->getLinks($s_ip, 10, \%V);
  $agent->getZones($DIR, $s_ip, $TO, \%V);
  $agent->getASIC($DIR, $s_ip, $TO, \%V);

#
# COUNTS
#
  my($STATE_LIST) = "LinkFails,Total_LIP_Rcvd,InvalidTxWds,SyncLosses,CRC_Errs," .
               "Prim_Seq_Errs,AL_Init_Errs,AddressIdErrs,short_frame_err_cnt,"  .
              "long_frame_err_cnt,loss_of_signal_cnt,sync_loss,Discards," .
               "AL_Inits,LIF_flow_cntrl_err_cnt,lof_timeout_els," .
               "lof_timeout,";

  $in = "";
  foreach $l (@$counts) {
     chomp($l);
     @b = split(/\s*:\s*/, $l);
     next if ($b[0] =~ /-----------/);
     if (substr($l,0,5) eq "Port:") {
        $in = $b[1]; # sprintf("%3.3d", $b[1]);  
     } elsif ($in) {
        my($k) = $b[0];
        $k =~ s/ /_/g;
        $k =~ s/,/_/g;
        if (index($STATE_LIST, $k) >= 0) {
	     $b[0] =~ s/ /_/g;
             $V{"port.$in.error.$b[0]"}   = $b[1];
        } else {
	     
	     $b[0] =~ s/ /_/g;
             $V{"port.$in.stats.$b[0]"}   = $b[1];
        }
     }

  }
  $V{'port.count'} = $in;

#
# PORT STATE
#
  $in = ""; my($port, $admin, $op );
  foreach $l (@$state) {
    chomp($l);
    $port = "";
    $l =~ /Port:\s*(\d+)\s*Admin:\s*(\w+),\s*Operational:\s*(\w+)/;
    $port  = $1;
    $admin = $2;
    $op    = $3;
    if ($port) {
       $port = $port ; # sprintf("%3.3d", $port);
       $V{"port.$port.port"}          = $port;
       $V{"port.$port.admin"}         = $admin;
       $V{"port.$port.operational"}   = $op;
    }
  }
  Debug->dump('switchConfig', \%V);

  $agent->addIdentification(\%V);

  return ("", $V{"id.wwn"}, \%V );
}

sub FRUS {
  my($class, $r, $name) = @_;
  my($v) = $r->{_value};
  my $devtype = $r->category();
  my $model = 'Qlogic-' . $v->{"version.ports"};
  my @FRUS;
  my $rev = $v->{"version.PROM"} . "-".  $v->{"version.FLASH"} . 
             "-" . $v->{"version.HW"};

  my $type = $v->{"id.device_userLabel"};
  push(@FRUS, [$name, $devtype, "switch", $type, "Qlogic", $model, " N/A", $rev, " N/A"]);
  return \@FRUS;

}


sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($v) = $r->{_value};


  $out .= $class->reportHead("SWITCH", $r, undef, $v->{"id.connect_errs"});

  my($version) = $v->subset("version.");
  my($cnt) =0;
  foreach my $x (sort keys %$version) {
    $out .= "<tr>" if ($cnt++ % 2 == 0);
    $out .= "<td align=right bgcolor=#DDDDFF><b>$x:<td>$version->{$x}</td>";
  }
  $out .= "<tr><td align=right bgcolor=#DDDDFF><b>Temp:<td>$v->{'chassis.temp.status'} / $v->{'chassis.temp.value'}</td>".
          "<td align=right bgcolor=#DDDDFF><b>IP:<td>$v->{'id.ipno'}</td>";
  $out .= "<tr><td align=right bgcolor=#DDDDFF><b>Fan:<td>$v->{'chassis.fan.1.status'} / $v->{'chassis.fan.2.status'}</td>".
          "<td align=right bgcolor=#DDDDFF><b>Power:<td>$v->{'chassis.power.status'}</td>";
     
      
  $out .= "
  </table>
  <table border=0><tr><td></table>
  <table border=1 cellspacing=0 cellpadding=1 width=95% bgcolor=white>
  <tr bgcolor=#DDDDFF>
    <th><font >Component</th>
    <th><font >Type</th>
    <th><font >Info</th>
  ";

  my($name) = $r->{_id}{name};
#  my($mon) = &mon('switch',$name);

  my($b, $status, $mode, $type, $p0, $p);
  $cnt = 0;
  for ($p0=1; $p0 <= 16; $p0++) {
     $p = $p0; # sprintf("%3.3d", $p0);
     last if (!$v->{"port.$p.type"});

     $status = $v->{"port.$p.mode"};
     my $bg = ($status eq "Online")? "":"bgcolor=#FFFFD0";
     $mode = $v->{"port.$p.operational"};
     $mode = "(op:$mode)" if ($mode);
     $type = $v->{"port.$p.type"};
     $out .= "<tr>
  <td>&nbsp;port." . ($p+0) .
  "<td>&nbsp;$type</td>
  <td $bg>$status $mode</td>
  \n";
     $cnt++;
  }
  my($zones) = $v->{'zone.total'};
  my($val);

  # zone.hd.0.members
  my $Z = $v->subset('zone');
  foreach my $x (keys %$Z) {
     next if ($x eq "total");
     my $x0 = $x;
     $x0 =~ s/\.members//;
     $val = $Z->{$x};
     $val =~ s/ /, /g;
     $out .= "<tr>
 <td>&nbsp;$x0</td>
 <td>&nbsp;Zone</td>
 <td>&nbsp;members: $val</td>
 \n";
     $cnt++;
  }

  if (!$tableCnt) {
    $out .= "</table>";
  }
  return $out;

}


#Column 1 = Link Failures
#Column 2 = Loss of Signal
#Column 3 = Primitive Sequence Protocol Errors
#Column 4 = Invalid CRC
#Column 5 = Loss of Sync
#Column 6 = Invalid Transmitted Words
#Column 7 = Total Received Frames - Field not used for determining errors
#Column 8 = Total Transmitted Frames - Field not used for determining errors

#  $dev = $node->getDevice();

sub FCfromDevice {
  my($class, $dev) = @_;
  my($db, $VAR1);
  $ERR = undef;
  my $renv = System->get_renv();
  my $rc;
  if ($dev->{host} && ($dev->{host} ne $renv->{hostname} )) {
    $rc = Util::Http->getCommand($dev->{hostIpno}, 
                "Agent::SWITCH::FC1&name=$dev->{name}&fc=$dev->{fc}&primary=$dev->{primary}".
                "&ipno=$dev->{ipno}&HTTP=1", 30);
    $rc = "ERR $Util::Http::ERROR" if (!defined($rc));

    if (substr($rc,0,3) eq "ERR" ) {
      $ERR = $rc;
      return undef;
    } else {
      eval substr($rc,3);
      $ERR = $rc if (!$VAR1);
      return $VAR1;
    }
  } else {
    return &get_FC1($dev);
  }
}


sub get_FC1 {
  my($q) = @_;
  my($l, @b, @ST , @CNT);
  my $renv = System->get_renv();
  my $swport = $renv->{sanbox_port} || $SANBOX_PORT;
   
  my($primary) = "-f $q->{fc} $q->{primary}" if ($q->{primary});
  my $baseZero = $q->{baseZero}; # is 1 on switch2 and others that start a port 0

  my($s_ip) = $primary || $q->{ipno}; # thru primary switch if available

  my $name = $q->{name};
  my($sb) = System->get_home() . "/bin/sanbox";

  my($err0,$version) = Util->run_command("$sb version -port $swport $s_ip", "test", 20);
  my($v) = "@$version";
  $v =~ /WWN:\s+([0-9a-f]+)/;
  my($wwn) = $1;
  if (!$wwn) {
    if ( $q->{HTTP}) {
      print "ERR No wwn for $s_ip";
    } else { 
      return undef;
    }
  }

  my($err1,$counts) = Util->run_command("$sb port_counts -port $swport $s_ip all","test",20, {cache => 0});

  my($in) = ""; my($p) = "8";

  my($STATE_LIST) = "LinkFails,Total_LIP_Rcvd,InvalidTxWds,SyncLosses,CRC_Errs,".
                "Prim_Seq_Errs,AL_Init_Errs,AddressIdErrs,short_frame_err_cnt," .
                "Inframes,Outframes,long_frame_err_cnt,loss_of_signal_cnt,sync_loss";
  $in = "";
  foreach $l (@$counts) {
     chomp($l);
     @b = split(/\s*:\s*/, $l);
     next if ($b[0] =~ /-----------/);
     if (substr($l,0,5) eq "Port:") {
        $in = $b[1]; # sprintf("%3.3d", $b[1]);
     } elsif ($in) {
        my($k) = $b[0];
        $k =~ s/ /_/g;
        $k =~ s/,/_/g;
	if (index($STATE_LIST, $k) >= 0) {
             my $portno = $baseZero ? $in-1 : $in;
             $CNT[$portno]{$k}   = $b[1]+0;
        }
     }
  }
  my(%X, $port);
  my $start = $baseZero ? 0 : 1;
  for ($port=$start ; $port <= $#CNT; $port++) {
     my $c = $CNT[$port];
     next if (!$c);
     my($key) = "|$wwn|port.$port|switch";
     $X{$key} = "$c->{LinkFails}\t$c->{loss_of_signal_cnt}\t$c->{Prim_Seq_Errs}\t".
             "$c->{CRC_Errs}\t$c->{sync_loss}\t$c->{InvalidTxWds}\t$c->{Inframes}\t$c->{Outframes}";
  }
  my($out) = { enc => {$wwn => $name} , data => \%X };


  if ($q->{HTTP}) {
require Data::Dumper;
     print "OK " . Data::Dumper::Dumper($out);
  } else {
     return $out;
  }
}

#Port:           2
#Inframes:       10470092 
#Outframes:      17900116 
#Discards:       14 
#Fbsyframes:     0 
#C2Rjtframes:    0 
#LinkFails:      9 
#SyncLosses:     9 
#Prim Seq Errs:  0 
#InvalidTxWds:   217101 
#CRC Errs:       33 
#DelimiterErrs:  27 
#AddressIdErrs:  0 
#Link Reset In:  0 
#Link Reset Out: 0 
#OLS In:         0 
#OLS Out:        0 
#Total LIP Rcvd: 155 
#LIP F7 F7:      153 
#LIP F8 F7:      0 


1;
