/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class VolumeGroupSummary
implements XDRType,
SYMbolAPIConstants {
    private long volumeGroupCapacity;
    private int volumeCount;
    private long volumeCapacity;
    private boolean trayLossProtection;
    private boolean spindleSpeedMatch;
    private int spindleSpeed;

    public VolumeGroupSummary() {
    }

    public VolumeGroupSummary(VolumeGroupSummary volumeGroupSummary) {
        this.volumeGroupCapacity = volumeGroupSummary.volumeGroupCapacity;
        this.volumeCount = volumeGroupSummary.volumeCount;
        this.volumeCapacity = volumeGroupSummary.volumeCapacity;
        this.trayLossProtection = volumeGroupSummary.trayLossProtection;
        this.spindleSpeedMatch = volumeGroupSummary.spindleSpeedMatch;
        this.spindleSpeed = volumeGroupSummary.spindleSpeed;
    }

    public int getSpindleSpeed() {
        return this.spindleSpeed;
    }

    public boolean getSpindleSpeedMatch() {
        return this.spindleSpeedMatch;
    }

    public boolean getTrayLossProtection() {
        return this.trayLossProtection;
    }

    public long getVolumeCapacity() {
        return this.volumeCapacity;
    }

    public int getVolumeCount() {
        return this.volumeCount;
    }

    public long getVolumeGroupCapacity() {
        return this.volumeGroupCapacity;
    }

    public void setSpindleSpeed(int n) {
        this.spindleSpeed = n;
    }

    public void setSpindleSpeedMatch(boolean bl) {
        this.spindleSpeedMatch = bl;
    }

    public void setTrayLossProtection(boolean bl) {
        this.trayLossProtection = bl;
    }

    public void setVolumeCapacity(long l) {
        this.volumeCapacity = l;
    }

    public void setVolumeCount(int n) {
        this.volumeCount = n;
    }

    public void setVolumeGroupCapacity(long l) {
        this.volumeGroupCapacity = l;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupCapacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeCapacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.trayLossProtection = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.spindleSpeedMatch = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.spindleSpeed = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putLong(this.volumeGroupCapacity);
        xDROutputStream.putInt(this.volumeCount);
        xDROutputStream.putLong(this.volumeCapacity);
        xDROutputStream.putBoolean(this.trayLossProtection);
        xDROutputStream.putBoolean(this.spindleSpeedMatch);
        xDROutputStream.putInt(this.spindleSpeed);
        xDROutputStream.setLength(n);
    }
}

