/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.RepositoryFullPolicy;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.VolumeCandidate;

public class SnapshotCreationDescriptor
implements XDRType,
SYMbolAPIConstants {
    private AbstractVolRef baseVolume = new AbstractVolRef();
    private UserAssignedLabel snapshotLabel = new UserAssignedLabel();
    private UserAssignedLabel repositoryLabel = new UserAssignedLabel();
    private long repositoryCapacity;
    private int warnThreshold;
    private long extentStart;
    private long extentSize;
    private RepositoryFullPolicy repFullPolicy = new RepositoryFullPolicy();
    private VolumeCandidate candidate = new VolumeCandidate();
    private boolean noMapping;

    public SnapshotCreationDescriptor() {
    }

    public SnapshotCreationDescriptor(SnapshotCreationDescriptor snapshotCreationDescriptor) {
        this.baseVolume = snapshotCreationDescriptor.baseVolume;
        this.snapshotLabel = snapshotCreationDescriptor.snapshotLabel;
        this.repositoryLabel = snapshotCreationDescriptor.repositoryLabel;
        this.repositoryCapacity = snapshotCreationDescriptor.repositoryCapacity;
        this.warnThreshold = snapshotCreationDescriptor.warnThreshold;
        this.extentStart = snapshotCreationDescriptor.extentStart;
        this.extentSize = snapshotCreationDescriptor.extentSize;
        this.repFullPolicy = snapshotCreationDescriptor.repFullPolicy;
        this.candidate = snapshotCreationDescriptor.candidate;
        this.noMapping = snapshotCreationDescriptor.noMapping;
    }

    public AbstractVolRef getBaseVolume() {
        return this.baseVolume;
    }

    public VolumeCandidate getCandidate() {
        return this.candidate;
    }

    public long getExtentSize() {
        return this.extentSize;
    }

    public long getExtentStart() {
        return this.extentStart;
    }

    public boolean getNoMapping() {
        return this.noMapping;
    }

    public RepositoryFullPolicy getRepFullPolicy() {
        return this.repFullPolicy;
    }

    public long getRepositoryCapacity() {
        return this.repositoryCapacity;
    }

    public UserAssignedLabel getRepositoryLabel() {
        return this.repositoryLabel;
    }

    public UserAssignedLabel getSnapshotLabel() {
        return this.snapshotLabel;
    }

    public int getWarnThreshold() {
        return this.warnThreshold;
    }

    public void setBaseVolume(AbstractVolRef abstractVolRef) {
        this.baseVolume = abstractVolRef;
    }

    public void setCandidate(VolumeCandidate volumeCandidate) {
        this.candidate = volumeCandidate;
    }

    public void setExtentSize(long l) {
        this.extentSize = l;
    }

    public void setExtentStart(long l) {
        this.extentStart = l;
    }

    public void setNoMapping(boolean bl) {
        this.noMapping = bl;
    }

    public void setRepFullPolicy(RepositoryFullPolicy repositoryFullPolicy) {
        this.repFullPolicy = repositoryFullPolicy;
    }

    public void setRepositoryCapacity(long l) {
        this.repositoryCapacity = l;
    }

    public void setRepositoryLabel(UserAssignedLabel userAssignedLabel) {
        this.repositoryLabel = userAssignedLabel;
    }

    public void setSnapshotLabel(UserAssignedLabel userAssignedLabel) {
        this.snapshotLabel = userAssignedLabel;
    }

    public void setWarnThreshold(int n) {
        this.warnThreshold = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.baseVolume.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.snapshotLabel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.repositoryLabel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.repositoryCapacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.warnThreshold = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.extentStart = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.extentSize = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.repFullPolicy.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.candidate.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.noMapping = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.baseVolume.xdrEncode(xDROutputStream);
        this.snapshotLabel.xdrEncode(xDROutputStream);
        this.repositoryLabel.xdrEncode(xDROutputStream);
        xDROutputStream.putLong(this.repositoryCapacity);
        xDROutputStream.putInt(this.warnThreshold);
        xDROutputStream.putLong(this.extentStart);
        xDROutputStream.putLong(this.extentSize);
        this.repFullPolicy.xdrEncode(xDROutputStream);
        this.candidate.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.noMapping);
        xDROutputStream.setLength(n);
    }
}

