/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCAuthGenerator;
import devmgr.versioned.jrpc.RPCAuthType;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.RPCOpaqueAuth;
import devmgr.versioned.jrpc.XDRMessageIOV;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAuthentication;
import devmgr.versioned.symbol.UnicodeTranslator;
import java.net.InetAddress;
import java.security.MessageDigest;

public class SYMbolAuthGenerator
implements RPCAuthGenerator {
    private static final int DIGEST_LENGTH = 20;
    private int m_ClientIp;
    private SAIdentifier m_ArrayId;
    private long m_ConfigGeneration;
    private MessageDigest m_Sha;
    private byte[] m_Password;

    public SYMbolAuthGenerator(InetAddress inetAddress, SAIdentifier sAIdentifier) throws RPCError {
        byte[] byArray = inetAddress.getAddress();
        int n = 0;
        while (n < 4) {
            this.m_ClientIp = this.m_ClientIp << 8 | byArray[n] & 0xFF;
            ++n;
        }
        this.m_ArrayId = sAIdentifier;
        this.m_Password = new byte[0];
        this.m_ConfigGeneration = 0L;
        try {
            this.m_Sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            throw new RPCError("AUTH_ALGORITHM");
        }
    }

    public synchronized RPCOpaqueAuth getFinalAuthData(RPCOpaqueAuth rPCOpaqueAuth, XDRMessageIOV xDRMessageIOV) throws RPCError {
        int n = xDRMessageIOV.getMessageSize();
        int n2 = 0;
        int n3 = 0;
        this.m_Sha.reset();
        this.m_Sha.update(this.m_Password);
        while (n2 < n) {
            byte[] byArray = xDRMessageIOV.getBuffer(n3);
            int n4 = Math.min(byArray.length, n - n2);
            this.m_Sha.update(byArray, 0, n4);
            ++n3;
            n2 += n4;
        }
        byte[] byArray = this.m_Sha.digest();
        this.m_Sha.reset();
        this.m_Sha.update(this.m_Password);
        this.m_Sha.update(byArray);
        byArray = this.m_Sha.digest();
        int n5 = rPCOpaqueAuth.getInfo().length - 20;
        System.arraycopy(byArray, 0, rPCOpaqueAuth.getInfo(), n5, 20);
        return rPCOpaqueAuth;
    }

    public RPCOpaqueAuth getInitialAuthData() throws RPCError {
        RPCAuthType rPCAuthType = new RPCAuthType();
        RPCOpaqueAuth rPCOpaqueAuth = new RPCOpaqueAuth();
        SYMbolAuthentication sYMbolAuthentication = new SYMbolAuthentication();
        XDROutputStream xDROutputStream = new XDROutputStream();
        sYMbolAuthentication.setClientIp(this.m_ClientIp);
        sYMbolAuthentication.setArrayId(this.m_ArrayId);
        sYMbolAuthentication.setConfigGeneration(this.m_ConfigGeneration);
        sYMbolAuthentication.setDigest(new byte[20]);
        sYMbolAuthentication.xdrEncode(xDROutputStream);
        XDRMessageIOV xDRMessageIOV = xDROutputStream.getMessage();
        int n = xDRMessageIOV.getMessageSize();
        rPCOpaqueAuth.setInfo(new byte[n]);
        xDRMessageIOV.copyData(rPCOpaqueAuth.getInfo());
        rPCAuthType.setValue(-1430533119);
        rPCOpaqueAuth.setType(rPCAuthType);
        return rPCOpaqueAuth;
    }

    public void setConfigGeneration(long l) {
        this.m_ConfigGeneration = l;
    }

    public void setPassword(String string) {
        this.m_Password = UnicodeTranslator.getBytes(string);
    }
}

