/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.InterfaceSpeed;
import devmgr.versioned.symbol.SYMbolAPIConstants;
import devmgr.versioned.symbol.SpeedControl;

public class SATAInterface
implements XDRType,
SYMbolAPIConstants {
    private int channel;
    private InterfaceSpeed currentInterfaceSpeed = new InterfaceSpeed();
    private InterfaceSpeed maximumInterfaceSpeed = new InterfaceSpeed();
    private SpeedControl speedControl = new SpeedControl();
    private String part;
    private int revision;

    public SATAInterface() {
    }

    public SATAInterface(SATAInterface sATAInterface) {
        this.channel = sATAInterface.channel;
        this.currentInterfaceSpeed = sATAInterface.currentInterfaceSpeed;
        this.maximumInterfaceSpeed = sATAInterface.maximumInterfaceSpeed;
        this.speedControl = sATAInterface.speedControl;
        this.part = sATAInterface.part;
        this.revision = sATAInterface.revision;
    }

    public int getChannel() {
        return this.channel;
    }

    public InterfaceSpeed getCurrentInterfaceSpeed() {
        return this.currentInterfaceSpeed;
    }

    public InterfaceSpeed getMaximumInterfaceSpeed() {
        return this.maximumInterfaceSpeed;
    }

    public String getPart() {
        return this.part;
    }

    public int getRevision() {
        return this.revision;
    }

    public SpeedControl getSpeedControl() {
        return this.speedControl;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setCurrentInterfaceSpeed(InterfaceSpeed interfaceSpeed) {
        this.currentInterfaceSpeed = interfaceSpeed;
    }

    public void setMaximumInterfaceSpeed(InterfaceSpeed interfaceSpeed) {
        this.maximumInterfaceSpeed = interfaceSpeed;
    }

    public void setPart(String string) {
        this.part = string;
    }

    public void setRevision(int n) {
        this.revision = n;
    }

    public void setSpeedControl(SpeedControl speedControl) {
        this.speedControl = speedControl;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentInterfaceSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.maximumInterfaceSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.speedControl.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.part = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.revision = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.channel);
        this.currentInterfaceSpeed.xdrEncode(xDROutputStream);
        this.maximumInterfaceSpeed.xdrEncode(xDROutputStream);
        this.speedControl.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.part);
        xDROutputStream.putInt(this.revision);
        xDROutputStream.setLength(n);
    }
}

