/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.RuntimeDiagTestID;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class RuntimeDiagDescriptor
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef controllerRef = new ControllerRef();
    private RuntimeDiagTestID runtimeDiagTestID = new RuntimeDiagTestID();
    private int channel;
    private boolean usePattern;
    private byte[] pattern;

    public RuntimeDiagDescriptor() {
    }

    public RuntimeDiagDescriptor(RuntimeDiagDescriptor runtimeDiagDescriptor) {
        this.controllerRef = runtimeDiagDescriptor.controllerRef;
        this.runtimeDiagTestID = runtimeDiagDescriptor.runtimeDiagTestID;
        this.channel = runtimeDiagDescriptor.channel;
        this.usePattern = runtimeDiagDescriptor.usePattern;
        this.pattern = runtimeDiagDescriptor.pattern;
    }

    public int getChannel() {
        return this.channel;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public byte[] getPattern() {
        return this.pattern;
    }

    public RuntimeDiagTestID getRuntimeDiagTestID() {
        return this.runtimeDiagTestID;
    }

    public boolean getUsePattern() {
        return this.usePattern;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public void setPattern(byte[] byArray) {
        this.pattern = byArray;
    }

    public void setRuntimeDiagTestID(RuntimeDiagTestID runtimeDiagTestID) {
        this.runtimeDiagTestID = runtimeDiagTestID;
    }

    public void setUsePattern(boolean bl) {
        this.usePattern = bl;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.runtimeDiagTestID.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.usePattern = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.pattern = xDRInputStream.getFixedOpaque(64);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.controllerRef.xdrEncode(xDROutputStream);
        this.runtimeDiagTestID.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putBoolean(this.usePattern);
        xDROutputStream.putFixedOpaque(this.pattern, 64);
        xDROutputStream.setLength(n);
    }
}

