/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class RloginUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef controllerRef = new ControllerRef();
    private String interfaceName;
    private int channel;
    private boolean enableRlogin;

    public RloginUpdateDescriptor() {
    }

    public RloginUpdateDescriptor(RloginUpdateDescriptor rloginUpdateDescriptor) {
        this.controllerRef = rloginUpdateDescriptor.controllerRef;
        this.interfaceName = rloginUpdateDescriptor.interfaceName;
        this.channel = rloginUpdateDescriptor.channel;
        this.enableRlogin = rloginUpdateDescriptor.enableRlogin;
    }

    public int getChannel() {
        return this.channel;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public boolean getEnableRlogin() {
        return this.enableRlogin;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public void setEnableRlogin(boolean bl) {
        this.enableRlogin = bl;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.interfaceName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.enableRlogin = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.controllerRef.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.interfaceName);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putBoolean(this.enableRlogin);
        xDROutputStream.setLength(n);
    }
}

