/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class FirmwareUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private byte[] firmwareChunkImage;
    private byte[] firmwareVersion;
    private int offset;
    private int totalSize;
    private boolean stagedDownload;
    private int numberOfFiles;
    private int sizeOfStream;

    public FirmwareUpdateDescriptor() {
    }

    public FirmwareUpdateDescriptor(FirmwareUpdateDescriptor firmwareUpdateDescriptor) {
        this.firmwareChunkImage = firmwareUpdateDescriptor.firmwareChunkImage;
        this.firmwareVersion = firmwareUpdateDescriptor.firmwareVersion;
        this.offset = firmwareUpdateDescriptor.offset;
        this.totalSize = firmwareUpdateDescriptor.totalSize;
        this.stagedDownload = firmwareUpdateDescriptor.stagedDownload;
        this.numberOfFiles = firmwareUpdateDescriptor.numberOfFiles;
        this.sizeOfStream = firmwareUpdateDescriptor.sizeOfStream;
    }

    public byte[] getFirmwareChunkImage() {
        return this.firmwareChunkImage;
    }

    public byte[] getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSizeOfStream() {
        return this.sizeOfStream;
    }

    public boolean getStagedDownload() {
        return this.stagedDownload;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setFirmwareChunkImage(byte[] byArray) {
        this.firmwareChunkImage = byArray;
    }

    public void setFirmwareVersion(byte[] byArray) {
        this.firmwareVersion = byArray;
    }

    public void setNumberOfFiles(int n) {
        this.numberOfFiles = n;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void setSizeOfStream(int n) {
        this.sizeOfStream = n;
    }

    public void setStagedDownload(boolean bl) {
        this.stagedDownload = bl;
    }

    public void setTotalSize(int n) {
        this.totalSize = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.firmwareChunkImage = xDRInputStream.getVariableOpaque(32768);
        }
        if (xDRInputStream.getPosition() < n) {
            this.firmwareVersion = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.offset = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.totalSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.stagedDownload = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.numberOfFiles = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.sizeOfStream = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putVariableOpaque(this.firmwareChunkImage, 32768);
        xDROutputStream.putVariableOpaque(this.firmwareVersion);
        xDROutputStream.putInt(this.offset);
        xDROutputStream.putInt(this.totalSize);
        xDROutputStream.putBoolean(this.stagedDownload);
        xDROutputStream.putInt(this.numberOfFiles);
        xDROutputStream.putInt(this.sizeOfStream);
        xDROutputStream.setLength(n);
    }
}

