/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class EthernetInterface
implements XDRType,
SYMbolAPIConstants {
    private String interfaceName;
    private int channel;
    private int speed;
    private int ip;
    private String alias;
    private byte[] macAddr;
    private int gatewayIp;
    private int subnetMask;
    private boolean bootpUsed;
    private boolean rloginEnabled;
    private byte[] reserved1;
    private byte[] reserved2;

    public EthernetInterface() {
    }

    public EthernetInterface(EthernetInterface ethernetInterface) {
        this.interfaceName = ethernetInterface.interfaceName;
        this.channel = ethernetInterface.channel;
        this.speed = ethernetInterface.speed;
        this.ip = ethernetInterface.ip;
        this.alias = ethernetInterface.alias;
        this.macAddr = ethernetInterface.macAddr;
        this.gatewayIp = ethernetInterface.gatewayIp;
        this.subnetMask = ethernetInterface.subnetMask;
        this.bootpUsed = ethernetInterface.bootpUsed;
        this.rloginEnabled = ethernetInterface.rloginEnabled;
        this.reserved1 = ethernetInterface.reserved1;
        this.reserved2 = ethernetInterface.reserved2;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean getBootpUsed() {
        return this.bootpUsed;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getGatewayIp() {
        return this.gatewayIp;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getIp() {
        return this.ip;
    }

    public byte[] getMacAddr() {
        return this.macAddr;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public boolean getRloginEnabled() {
        return this.rloginEnabled;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getSubnetMask() {
        return this.subnetMask;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setBootpUsed(boolean bl) {
        this.bootpUsed = bl;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setGatewayIp(int n) {
        this.gatewayIp = n;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public void setIp(int n) {
        this.ip = n;
    }

    public void setMacAddr(byte[] byArray) {
        this.macAddr = byArray;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setRloginEnabled(boolean bl) {
        this.rloginEnabled = bl;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public void setSubnetMask(int n) {
        this.subnetMask = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.interfaceName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.speed = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.ip = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.alias = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.macAddr = xDRInputStream.getFixedOpaque(6);
        }
        if (xDRInputStream.getPosition() < n) {
            this.gatewayIp = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.subnetMask = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.bootpUsed = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.rloginEnabled = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putString(this.interfaceName);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.speed);
        xDROutputStream.putInt(this.ip);
        xDROutputStream.putString(this.alias);
        xDROutputStream.putFixedOpaque(this.macAddr, 6);
        xDROutputStream.putInt(this.gatewayIp);
        xDROutputStream.putInt(this.subnetMask);
        xDROutputStream.putBoolean(this.bootpUsed);
        xDROutputStream.putBoolean(this.rloginEnabled);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

