/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.symbol;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRInputStream;
import devmgr.versioned.jrpc.XDROutputStream;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerSFPType;
import devmgr.versioned.symbol.SYMbolAPIConstants;

public class ControllerSFP
implements XDRType,
SYMbolAPIConstants {
    private ControllerSFPType controllerSFPType = new ControllerSFPType();
    private ControllerRef parentController = new ControllerRef();
    private int channel;
    private byte[] reserved1;
    private byte[] reserved2;

    public ControllerSFP() {
    }

    public ControllerSFP(ControllerSFP controllerSFP) {
        this.controllerSFPType = controllerSFP.controllerSFPType;
        this.parentController = controllerSFP.parentController;
        this.channel = controllerSFP.channel;
        this.reserved1 = controllerSFP.reserved1;
        this.reserved2 = controllerSFP.reserved2;
    }

    public int getChannel() {
        return this.channel;
    }

    public ControllerSFPType getControllerSFPType() {
        return this.controllerSFPType;
    }

    public ControllerRef getParentController() {
        return this.parentController;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setControllerSFPType(ControllerSFPType controllerSFPType) {
        this.controllerSFPType = controllerSFPType;
    }

    public void setParentController(ControllerRef controllerRef) {
        this.parentController = controllerRef;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.controllerSFPType.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.parentController.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.controllerSFPType.xdrEncode(xDROutputStream);
        this.parentController.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

