/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRMessageIOV;

public class XDROutputStream {
    private static final int XDR_UNIT_SIZE = 4;
    private static final int XDR_BUFFER_SIZE = 1024;
    private XDRMessageIOV m_Msg = new XDRMessageIOV();
    private byte[] m_Buf = new byte[1024];
    private int m_Pos = 0;
    private int m_BufNum = 0;
    private boolean m_Growing = true;

    private int calculatePad(int n) {
        int n2 = 0;
        int n3 = n % 4;
        if (n3 != 0) {
            n2 = 4 - n3;
        }
        return n2;
    }

    private void finishMessage() {
        if (this.m_Growing && this.m_Pos > 0) {
            this.m_Msg.addLastBuffer(this.m_Buf, this.m_Pos);
            this.m_Buf = null;
            this.m_Growing = false;
        }
    }

    public XDRMessageIOV getMessage() {
        this.finishMessage();
        return this.m_Msg;
    }

    public int getPosition() {
        return this.m_Msg.getMessageSize() + this.m_Pos;
    }

    public int prepareLength() {
        this.putInt(0);
        return this.getPosition();
    }

    public void putBoolean(boolean bl) {
        this.putByte(0);
        this.putByte(0);
        this.putByte(0);
        this.putByte(bl ? 1 : 0);
    }

    private void putByte(int n) {
        if (this.m_Pos >= 1024) {
            if (this.m_Growing) {
                this.m_Msg.addFullBuffer(this.m_Buf);
                ++this.m_BufNum;
                this.m_Pos = 0;
                this.m_Buf = new byte[1024];
            } else {
                ++this.m_BufNum;
                this.m_Pos = 0;
                this.m_Buf = this.m_Msg.getBuffer(this.m_BufNum);
            }
        }
        this.m_Buf[this.m_Pos++] = (byte)n;
    }

    public void putChar(char c) {
        this.putByte(0);
        this.putByte(0);
        this.putByte(0);
        this.putByte(c);
    }

    public void putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
    }

    public void putFixedOpaque(byte[] byArray, int n) throws RPCError {
        int n2 = byArray.length;
        if (n2 != n) {
            throw new RPCError("XDR_MAX_LENGTH");
        }
        int n3 = this.calculatePad(n2);
        int n4 = 0;
        while (n4 < n2) {
            this.putByte(byArray[n4]);
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            this.putByte(0);
            ++n4;
        }
    }

    public void putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
    }

    public void putInt(int n) {
        this.putByte(n >>> 24);
        this.putByte(n >>> 16);
        this.putByte(n >>> 8);
        this.putByte(n);
    }

    public void putLong(long l) {
        this.putByte((int)(l >>> 56));
        this.putByte((int)(l >>> 48));
        this.putByte((int)(l >>> 40));
        this.putByte((int)(l >>> 32));
        this.putByte((int)(l >>> 24));
        this.putByte((int)(l >>> 16));
        this.putByte((int)(l >>> 8));
        this.putByte((int)l);
    }

    public void putShort(short s) {
        this.putByte(0);
        this.putByte(0);
        this.putByte(s >>> 8);
        this.putByte(s);
    }

    public void putString(String string) {
        int n = string.length();
        this.putInt(n);
        int n2 = this.calculatePad(n);
        int n3 = 0;
        while (n3 < n) {
            this.putByte(string.charAt(n3));
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.putByte(0);
            ++n3;
        }
    }

    public void putString(String string, int n) throws RPCError {
        if (string.length() > n) {
            throw new RPCError("XDR_MAX_LENGTH");
        }
        this.putString(string);
    }

    public void putVariableOpaque(byte[] byArray) throws RPCError {
        int n = byArray == null ? 0 : byArray.length;
        this.putInt(n);
        if (n > 0) {
            this.putFixedOpaque(byArray, n);
        }
    }

    public void putVariableOpaque(byte[] byArray, int n) throws RPCError {
        if (byArray.length > n) {
            throw new RPCError("XDR_MAX_LENGTH");
        }
        this.putVariableOpaque(byArray);
    }

    public void setLength(int n) {
        int n2 = this.getPosition() - n;
        int n3 = (n - 4) / 1024;
        int n4 = (n - 4) % 1024;
        byte[] byArray = n3 == this.m_BufNum ? this.m_Buf : this.m_Msg.getBuffer(n3);
        byArray[n4] = (byte)(n2 >>> 24);
        byArray[n4 + 1] = (byte)(n2 >>> 16);
        byArray[n4 + 2] = (byte)(n2 >>> 8);
        byArray[n4 + 3] = (byte)n2;
    }

    public void setPosition(int n) {
        this.finishMessage();
        this.m_BufNum = n / 1024;
        this.m_Pos = n % 1024;
        this.m_Buf = this.m_Msg.getBuffer(this.m_BufNum);
    }
}

