/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRMessageIOV;

public class XDRInputStream {
    private static final int XDR_UNIT_SIZE = 4;
    private XDRMessageIOV m_Msg;
    private int m_TotalBytes;
    private int m_TotalConsumed;
    private int m_NextBuf;
    private byte[] m_Buf;
    private int m_BufSize;
    private int m_BufPos;

    public XDRInputStream(XDRMessageIOV xDRMessageIOV) {
        this.m_Msg = xDRMessageIOV;
        this.m_TotalBytes = this.m_Msg.getMessageSize();
        this.m_TotalConsumed = 0;
        this.m_NextBuf = 0;
        this.m_Buf = null;
        this.m_BufSize = 0;
        this.m_BufPos = 0;
    }

    private int calculatePad(int n) {
        int n2 = 0;
        int n3 = n % 4;
        if (n3 != 0) {
            n2 = 4 - n3;
        }
        return n2;
    }

    private String fetchString(int n) throws RPCError {
        int n2;
        int n3 = this.calculatePad(n);
        char[] cArray = new char[n];
        if (this.m_BufPos + n - 1 >= this.m_BufSize) {
            n2 = 0;
            while (n2 < n) {
                cArray[n2] = (char)this.getByte();
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < n) {
                cArray[n2] = (char)this.m_Buf[this.m_BufPos++];
                ++n2;
            }
            this.m_TotalConsumed += n;
        }
        if (this.m_BufPos + n3 - 1 >= this.m_BufSize) {
            n2 = 0;
            while (n2 < n3) {
                this.getByte();
                ++n2;
            }
        } else {
            this.m_BufPos += n3;
            this.m_TotalConsumed += n3;
        }
        return String.copyValueOf(cArray);
    }

    public boolean getBoolean() throws RPCError {
        int n = this.getInt();
        boolean bl = (n & 0xFF) != 0;
        return bl;
    }

    private byte getByte() throws RPCError {
        if (this.m_BufPos >= this.m_BufSize) {
            if (this.m_TotalConsumed >= this.m_TotalBytes) {
                throw new RPCError("XDR_UNDERFLOW");
            }
            this.m_Buf = this.m_Msg.getBuffer(this.m_NextBuf++);
            this.m_BufPos = 0;
            this.m_BufSize = Math.min(this.m_Buf.length, this.m_TotalBytes - this.m_TotalConsumed);
        }
        ++this.m_TotalConsumed;
        return this.m_Buf[this.m_BufPos++];
    }

    public char getChar() throws RPCError {
        int n = this.getInt();
        return (char)(n & 0xFF);
    }

    public double getDouble() throws RPCError {
        long l = this.getLong();
        return Double.longBitsToDouble(l);
    }

    public byte[] getFixedOpaque(int n) throws RPCError {
        int n2;
        int n3 = this.calculatePad(n);
        byte[] byArray = new byte[n];
        if (this.m_BufPos + n - 1 >= this.m_BufSize) {
            n2 = 0;
            while (n2 < n) {
                byArray[n2] = this.getByte();
                ++n2;
            }
        } else {
            System.arraycopy(this.m_Buf, this.m_BufPos, byArray, 0, n);
            this.m_BufPos += n;
            this.m_TotalConsumed += n;
        }
        if (this.m_BufPos + n3 - 1 >= this.m_BufSize) {
            n2 = 0;
            while (n2 < n3) {
                this.getByte();
                ++n2;
            }
        } else {
            this.m_BufPos += n3;
            this.m_TotalConsumed += n3;
        }
        return byArray;
    }

    public float getFloat() throws RPCError {
        int n = this.getInt();
        return Float.intBitsToFloat(n);
    }

    public int getInt() throws RPCError {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.m_BufPos + 3 >= this.m_BufSize) {
            n4 = this.getByte() & 0xFF;
            n3 = this.getByte() & 0xFF;
            n2 = this.getByte() & 0xFF;
            n = this.getByte() & 0xFF;
        } else {
            n4 = this.m_Buf[this.m_BufPos++] & 0xFF;
            n3 = this.m_Buf[this.m_BufPos++] & 0xFF;
            n2 = this.m_Buf[this.m_BufPos++] & 0xFF;
            n = this.m_Buf[this.m_BufPos++] & 0xFF;
            this.m_TotalConsumed += 4;
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public long getLong() throws RPCError {
        return (long)this.getInt() << 32 | (long)this.getInt() & 0xFFFFFFFFL;
    }

    public int getPosition() {
        return this.m_TotalConsumed;
    }

    public int getRemainingLength() {
        return this.m_TotalBytes - this.m_TotalConsumed;
    }

    public short getShort() throws RPCError {
        return (short)(this.getInt() & 0xFFFF);
    }

    public String getString() throws RPCError {
        int n = this.getInt();
        return this.fetchString(n);
    }

    public String getString(int n) throws RPCError {
        int n2 = this.getInt();
        if (n2 > n) {
            throw new RPCError("XDR_MAX_LENGTH");
        }
        return this.fetchString(n2);
    }

    public byte[] getVariableOpaque() throws RPCError {
        int n = this.getInt();
        return this.getFixedOpaque(n);
    }

    public byte[] getVariableOpaque(int n) throws RPCError {
        int n2 = this.getInt();
        if (n2 > n) {
            throw new RPCError("XDR_MAX_LENGTH");
        }
        return this.getFixedOpaque(n2);
    }

    public void setPosition(int n) {
        if (n < 0 || n >= this.m_TotalBytes) {
            this.m_TotalConsumed = this.m_TotalBytes;
            this.m_Buf = null;
            this.m_BufSize = 0;
            this.m_BufPos = 0;
            this.m_NextBuf = 0;
        } else {
            this.m_NextBuf = 0;
            this.m_Buf = this.m_Msg.getBuffer(this.m_NextBuf++);
            this.m_BufSize = Math.min(this.m_Buf.length, this.m_TotalBytes);
            this.m_TotalConsumed = 0;
            while (this.m_TotalConsumed + this.m_BufSize < n) {
                this.m_TotalConsumed += this.m_BufSize;
                this.m_Buf = this.m_Msg.getBuffer(this.m_NextBuf++);
                this.m_BufSize = Math.min(this.m_Buf.length, this.m_TotalBytes - this.m_TotalConsumed);
            }
            this.m_BufPos = n - this.m_TotalConsumed;
            this.m_TotalConsumed = n;
        }
    }

    public void skip(int n) throws RPCError {
        int n2 = 0;
        while (n2 < n) {
            this.getByte();
            ++n2;
        }
    }
}

