/*
 * Decompiled with CFR 0.152.
 */
package devmgr.versioned.jrpc;

import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRMessageIOV;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class TCPChannel {
    private Socket m_Sock = null;
    private OutputStream m_Out = null;
    private InputStream m_In = null;

    public TCPChannel(Socket socket) throws IOException {
        this.m_Sock = socket;
        this.m_Out = this.m_Sock.getOutputStream();
        this.m_In = this.m_Sock.getInputStream();
    }

    public void close() throws IOException {
        this.m_In.close();
        this.m_In = null;
        this.m_Out.close();
        this.m_Out = null;
        this.m_Sock.close();
        this.m_Sock = null;
    }

    protected void finalize() throws Throwable {
        if (this.m_In != null) {
            this.m_In.close();
        }
        if (this.m_Out != null) {
            this.m_Out.close();
        }
        if (this.m_Sock != null) {
            this.m_Sock.close();
        }
    }

    public InetAddress getLocalAddress() {
        return this.m_Sock.getLocalAddress();
    }

    public InetAddress getServerAddress() {
        return this.m_Sock.getInetAddress();
    }

    private void readFully(byte[] byArray, int n, int n2) throws RPCError, IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            try {
                n4 = this.m_In.read(byArray, n + n3, n2 - n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new RPCError("TIMEOUT");
            }
            if (n4 <= 0) {
                throw new RPCError("CONNECTION_LOST");
            }
            n3 += n4;
        }
    }

    public XDRMessageIOV receiveMsg() throws RPCError, IOException {
        XDRMessageIOV xDRMessageIOV = new XDRMessageIOV();
        byte[] byArray = new byte[4];
        boolean bl = false;
        while (!bl) {
            this.readFully(byArray, 0, byArray.length);
            int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            int n2 = n & Integer.MAX_VALUE;
            if (n2 != 0) {
                byte[] byArray2 = new byte[n2];
                this.readFully(byArray2, 0, n2);
                xDRMessageIOV.addFullBuffer(byArray2);
            }
            boolean bl2 = bl = (n & Integer.MIN_VALUE) != 0;
        }
        return xDRMessageIOV;
    }

    public void sendMsg(XDRMessageIOV xDRMessageIOV) throws RPCError, IOException {
        int n = xDRMessageIOV.getMessageSize();
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[4];
        while (n2 < n) {
            int n4;
            byte[] byArray2 = xDRMessageIOV.getBuffer(n3++);
            int n5 = n4 = Math.min(byArray2.length, n - n2);
            if (n2 + n4 >= n) {
                n5 |= Integer.MIN_VALUE;
            }
            byArray[0] = (byte)(n5 >>> 24);
            byArray[1] = (byte)(n5 >>> 16);
            byArray[2] = (byte)(n5 >>> 8);
            byArray[3] = (byte)n5;
            this.m_Out.write(byArray);
            this.m_Out.write(byArray2, 0, n4);
            n2 += n4;
        }
        this.m_Out.flush();
    }

    public void setTimeout(int n) throws IOException {
        this.m_Sock.setSoTimeout(n * 1000);
    }
}

