/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class LocalizedString
implements Serializable {
    private String resource;
    private String property;
    private String defaultValue;
    private Object[] args;

    public String getResource() {
        return this.resource;
    }

    public String getProperty() {
        return this.property;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public LocalizedString() {
    }

    public LocalizedString(String inValue) {
        String value = this.decode(inValue);
        try {
            int iEnd = value.indexOf(0);
            if (iEnd < 0) {
                this.defaultValue = value;
            } else {
                int iResource = value.indexOf(58, iEnd + 1);
                int iProperty = value.indexOf(58, iResource + 1);
                int iArg = value.indexOf(58, iProperty + 1);
                this.resource = value.substring(iResource + 1, iProperty);
                this.property = value.substring(iProperty + 1, iArg);
                this.defaultValue = value.substring(0, iEnd);
                ArrayList list = new ArrayList();
                while (iArg > 0) {
                    iArg = this.DeserializeObject(value, iArg, list);
                }
                if (list.size() > 0) {
                    this.args = list.toArray();
                }
            }
        }
        catch (Exception e) {
            this.resource = null;
            this.property = null;
            this.defaultValue = value;
        }
    }

    public LocalizedString(String resource, String property, String defaultValue) {
        this.resource = resource;
        this.property = property;
        this.defaultValue = defaultValue != null ? defaultValue : property;
    }

    public LocalizedString(String resource, String property) {
        this(resource, property, property);
    }

    public LocalizedString(String resource, String property, String defaultValue, Object[] args) {
        this.resource = resource;
        this.property = property;
        this.defaultValue = defaultValue != null ? defaultValue : property;
        this.args = args;
    }

    public LocalizedString(Exception e) {
        this.resource = null;
        this.property = null;
        if (e != null) {
            this.defaultValue = e.getLocalizedMessage();
        }
    }

    public String getMessage() {
        return this.getString();
    }

    public String getMessage(Locale locale) {
        return this.getString(locale);
    }

    public String toString() {
        if (this.resource == null || this.property == null) {
            return this.defaultValue;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.encode(this.defaultValue));
        buf.append("\\0");
        if (this.resource != null) {
            buf.append(":");
            buf.append(this.resource);
            buf.append(":");
        }
        if (this.property != null) {
            buf.append(this.property);
        }
        buf.append(":");
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                Object o = this.args[i];
                if (o instanceof Double) {
                    buf.append("D");
                    buf.append(o.toString());
                    buf.append(":");
                } else if (o instanceof Float) {
                    buf.append("F");
                    buf.append(o.toString());
                    buf.append(":");
                } else if (o instanceof Long) {
                    buf.append("L");
                    buf.append(o.toString());
                    buf.append(":");
                } else if (o instanceof Number) {
                    buf.append("#");
                    buf.append(o.toString());
                    buf.append(":");
                } else if (o instanceof String) {
                    buf.append("S");
                    buf.append(((String)o).length());
                    buf.append(":");
                    buf.append(o.toString());
                    buf.append(":");
                } else {
                    String s = this.SerializeObject(o);
                    buf.append("O");
                    buf.append(s.length());
                    buf.append(":");
                    buf.append(s);
                    buf.append(":");
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public int hashCode() {
        int hash = 0;
        if (this.resource != null) {
            hash += this.resource.hashCode();
        }
        if (this.property != null) {
            hash += this.property.hashCode();
        }
        if (this.defaultValue != null) {
            hash += this.defaultValue.hashCode();
        }
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                if (this.args[i] != null) {
                    hash += this.args[i].hashCode();
                }
                ++i;
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalizedString)) {
            return false;
        }
        LocalizedString ls = (LocalizedString)obj;
        return this.toString().equals(ls.toString());
    }

    public Object clone() {
        if (this.args != null) {
            try {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(data);
                out.writeObject(this.args);
                ByteArrayInputStream datain = new ByteArrayInputStream(data.toByteArray());
                ObjectInputStream in = new ObjectInputStream(datain);
                return new LocalizedString(new String(this.resource), new String(this.property), new String(this.defaultValue), (Object[])in.readObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalizedString(new String(this.resource), new String(this.property), new String(this.defaultValue));
    }

    public static String localize(String in) {
        LocalizedString ls = new LocalizedString(in);
        return ls.getString();
    }

    public static String localize(String in, Locale inLocale) {
        LocalizedString ls = new LocalizedString(in);
        return ls.getString(inLocale);
    }

    public String getString() {
        String value = this.getValueFromResource(null);
        if (value == null) {
            value = this.defaultValue;
        }
        if (this.args != null && this.args.length > 0) {
            return MessageFormat.format(value, this.localizeArgs(null));
        }
        return value;
    }

    public String getString(Locale inLocale) {
        String value = this.getValueFromResource(inLocale);
        if (value == null) {
            value = this.defaultValue;
        }
        if (this.args != null && this.args.length > 0) {
            return MessageFormat.format(value, this.localizeArgs(inLocale));
        }
        return value;
    }

    public void setDefaultValue() {
        this.setDefaultValue(this.getString());
    }

    public void setDefaultValue(Locale locale) {
        this.setDefaultValue(this.getString(locale));
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    private int DeserializeObject(String s, int offset, ArrayList list) {
        if (s.length() <= offset + 1) {
            return -1;
        }
        int endIndex = s.indexOf(":", offset + 2);
        String lenValue = s.substring(offset + 2, endIndex);
        switch (s.charAt(offset + 1)) {
            case 'D': {
                list.add(Double.valueOf(lenValue));
                break;
            }
            case 'F': {
                list.add(Float.valueOf(lenValue));
                break;
            }
            case 'L': {
                list.add(Double.valueOf(lenValue));
                break;
            }
            case '#': {
                list.add(Integer.valueOf(lenValue));
                break;
            }
            case 'S': {
                Integer lenInt = Integer.valueOf(lenValue);
                int len = lenInt;
                list.add(s.substring(endIndex + 1, endIndex + 1 + len));
                endIndex += len + 1;
                break;
            }
            case 'O': {
                Integer lenInt = Integer.valueOf(lenValue);
                int len = lenInt;
                String sv = s.substring(endIndex + 1, endIndex + 1 + len);
                byte[] data = new byte[len];
                int i = 0;
                while (i < len) {
                    data[i] = (byte)sv.charAt(i);
                    ++i;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    Object outObj = ois.readObject();
                    list.add(outObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -1;
                }
                endIndex += len + 1;
            }
        }
        return endIndex;
    }

    private String SerializeObject(Object o) {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(data);
            out.writeObject(o);
            int mi = data.size();
            StringBuffer encodedBuf = new StringBuffer();
            byte[] obdata = data.toByteArray();
            int i = 0;
            while (i < mi) {
                encodedBuf.append((char)obdata[i]);
                ++i;
            }
            return encodedBuf.toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private String getValueFromResource(Locale inLocale) {
        if (this.resource == null || this.property == null) {
            return null;
        }
        try {
            ResourceBundle rb = inLocale == null ? ResourceBundle.getBundle(this.resource) : ResourceBundle.getBundle(this.resource, inLocale);
            return rb.getString(this.property);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    private Object[] localizeArgs(Locale inLocale) {
        Object[] nargs = new Object[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            if (this.args[i] instanceof String) {
                LocalizedString ls = new LocalizedString((String)this.args[i]);
                nargs[i] = ls.getString(inLocale);
            } else {
                nargs[i] = this.args[i];
            }
            ++i;
        }
        return nargs;
    }

    private String encode(String inString) {
        if (inString == null) {
            return null;
        }
        int len = inString.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = inString.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private String decode(String inString) {
        if (inString == null) {
            return null;
        }
        int len = inString.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = inString.charAt(i);
            if (c == '\\') {
                char nc;
                if ((nc = inString.charAt(++i)) == '0') {
                    buf.append('\u0000');
                } else if (nc == '\\') {
                    buf.append('\\');
                } else {
                    buf.append(nc);
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    private class ByteStream
    extends ByteArrayOutputStream {
        ByteStream() {
        }

        public String toString() {
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < this.count) {
                strBuf.append((char)this.buf[i]);
                ++i;
            }
            return strBuf.toString();
        }
    }
}

