/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.util;

import com.sun.netstorage.fm.storade.util.ResourceLock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.LinkedList;

public class LockManager {
    public static final String FRU_SEPARATOR = "~";
    public static final String LOCK_DIR = "/tmp/MgmtLocks";
    public static final String MASTERLOCK = "MASTERLOCK";
    public static final String LOCK_EXT = ".lock";
    private String[] resourceNames;
    private FileLock masterLock;
    private FileOutputStream masterStream;
    private FileChannel masterChannel;
    private long lockTime;
    private String application = "Java";
    private String description = "";
    private String ip_address = "localhost";
    private String userName = "nobody";
    private static String pid;
    private static boolean TRACE;
    public static final String sccs_id = "$Revision";

    public LockManager(String resourceName) {
        this.resourceNames = new String[]{resourceName};
    }

    public LockManager(String[] resourceNames) {
        this.resourceNames = resourceNames;
    }

    public void setInfo(String application, String description, String ip_address, String userName) {
        this.application = application;
        this.description = description;
        this.ip_address = ip_address;
        this.userName = userName;
    }

    public synchronized boolean lock(int length, int wait) {
        long waitTime = System.currentTimeMillis() + (long)(wait * 1000);
        do {
            boolean locked;
            if (locked = this.lock(length)) {
                return true;
            }
            try {
                this.wait(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < waitTime);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean lock(int length) {
        boolean curTime2;
        try {
            try {
                if (this.lockMaster()) {
                    long curTime2 = System.currentTimeMillis() / 1000L;
                    long expTime = curTime2 + (long)length;
                    ResourceLock[] locks = new ResourceLock[this.resourceNames.length];
                    int i = 0;
                    while (true) {
                        if (i >= this.resourceNames.length) break;
                        locks[i] = new ResourceLock(this.resourceNames[i]);
                        locks[i].readLock();
                        if (locks[i].isLocked()) {
                            boolean bl = false;
                            Object var10_11 = null;
                            this.unlockMaster();
                            return bl;
                        }
                        if (locks[i].isFRULocked()) {
                            boolean bl = false;
                            Object var10_12 = null;
                            this.unlockMaster();
                            return bl;
                        }
                        locks[i].setInfo(this.application, this.description, this.ip_address, this.userName);
                        ++i;
                    }
                    boolean bl = this.dolocks(locks, expTime);
                    Object var10_13 = null;
                    this.unlockMaster();
                    return bl;
                }
                curTime2 = false;
            }
            catch (Exception e) {
                if (TRACE) {
                    e.printStackTrace();
                }
                boolean bl = false;
                Object var10_15 = null;
                this.unlockMaster();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.unlockMaster();
            throw throwable;
        }
        Object var10_14 = null;
        this.unlockMaster();
        return curTime2;
    }

    public synchronized void unlock() throws IOException {
        int i = 0;
        while (i < this.resourceNames.length) {
            ResourceLock lock = new ResourceLock(this.resourceNames[i]);
            lock.readLock();
            lock.unlock();
            ++i;
        }
    }

    public boolean isLocked() {
        return this.lockTime > System.currentTimeMillis();
    }

    public boolean checkLocked() throws IOException {
        int i = 0;
        while (i < this.resourceNames.length) {
            ResourceLock lock = new ResourceLock(this.resourceNames[i]);
            lock.readLock();
            if (lock.isLocked()) {
                return true;
            }
            if (lock.isFRULocked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getPid() {
        return pid;
    }

    private boolean dolocks(ResourceLock[] locks, long expTime) throws IOException {
        boolean locked;
        block5: {
            locked = false;
            try {
                int i = 0;
                while (i < locks.length) {
                    locks[i].lock(expTime, null);
                    ++i;
                }
                this.lockTime = expTime;
                locked = true;
            }
            catch (Exception e) {
                if (!TRACE) break block5;
                e.printStackTrace();
            }
        }
        if (!locked) {
            int i = 0;
            while (i < locks.length) {
                locks[i].unlock();
                ++i;
            }
        }
        return locked;
    }

    private synchronized boolean lockMaster() {
        return this.lockMaster(false);
    }

    private synchronized boolean lockMaster(boolean doBlock) {
        if (this.masterLock != null) {
            return true;
        }
        try {
            File lockDir = new File(LOCK_DIR);
            lockDir.mkdirs();
            File masterFile = new File(LOCK_DIR, MASTERLOCK);
            masterFile.createNewFile();
            this.masterStream = new FileOutputStream(masterFile);
            this.masterChannel = this.masterStream.getChannel();
            this.masterLock = doBlock ? this.masterChannel.lock() : this.masterChannel.tryLock();
            if (this.masterLock.isValid()) {
                PrintWriter out = new PrintWriter(this.masterStream);
                out.println(LockManager.getMasterExpire());
                out.println(LockManager.getPid());
                out.println(this.toString());
                out.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (TRACE) {
                e.printStackTrace();
            }
            this.unlockMaster();
            return false;
        }
    }

    private void clearMaster() {
        block2: {
            try {
                File masterFile = new File(LOCK_DIR, MASTERLOCK);
                FileWriter out = new FileWriter(masterFile);
                out.write(48);
                out.write(10);
                out.close();
            }
            catch (IOException ioe1) {
                if (!TRACE) break block2;
                ioe1.printStackTrace();
            }
        }
    }

    private void unlockMaster() {
        block11: {
            block10: {
                block9: {
                    try {
                        if (this.masterLock != null && this.masterLock.isValid()) {
                            this.clearMaster();
                            this.masterLock.release();
                        }
                    }
                    catch (IOException ioe1) {
                        if (!TRACE) break block9;
                        ioe1.printStackTrace();
                    }
                }
                try {
                    if (this.masterChannel != null) {
                        this.masterChannel.close();
                    }
                }
                catch (IOException ioe2) {
                    if (!TRACE) break block10;
                    ioe2.printStackTrace();
                }
            }
            try {
                if (this.masterStream != null) {
                    this.masterStream.close();
                }
            }
            catch (IOException ioe3) {
                if (!TRACE) break block11;
                ioe3.printStackTrace();
            }
        }
        this.masterLock = null;
        this.masterChannel = null;
        this.masterStream = null;
    }

    private void finishedOp() {
        this.notify();
    }

    private synchronized boolean lockMaster(long limit) {
        MasterLocker ml = new MasterLocker();
        Thread t = new Thread(ml);
        t.start();
        long startTime = System.currentTimeMillis();
        try {
            this.wait(limit);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.masterLock != null) {
            return true;
        }
        if (startTime + limit >= System.currentTimeMillis()) {
            ml.setTimedOut();
            return false;
        }
        return false;
    }

    private static String setDefaultPID() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private static String getMasterExpire() {
        return Long.toString(System.currentTimeMillis() / 1000L + 30L);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage ResourceLock <command> [args]");
            System.err.println("Commands: lock   <seconds> [resources]");
            System.err.println("          unlock <seconds> [resources]");
            System.err.println("          check  [resources]");
            System.exit(-1);
        }
        TRACE = true;
        try {
            if ("lock".equals(args[0])) {
                int duration = Integer.parseInt(args[1]);
                String[] res = new String[args.length - 2];
                int i = 0;
                while (i < res.length) {
                    res[i] = args[i + 2];
                    ++i;
                }
                LockManager lm = new LockManager(res);
                if (lm.lock(duration)) {
                    System.out.println("locked!");
                } else {
                    System.out.println("lock failure");
                }
            } else if ("unlock".equals(args[0])) {
                int duration = Integer.parseInt(args[1]);
                String[] res = new String[args.length - 2];
                int i = 0;
                while (i < res.length) {
                    res[i] = args[i + 2];
                    ++i;
                }
                LockManager lm = new LockManager(res);
                if (lm.checkLocked()) {
                    lm.unlock();
                    System.out.println("unlocked.");
                } else {
                    System.out.println("Resources already unlocked.");
                }
            } else if ("check".equals(args[0])) {
                String[] res = new String[args.length - 1];
                int i = 0;
                while (i < res.length) {
                    res[i] = args[i + 1];
                    ++i;
                }
                LockManager lm = new LockManager(res);
                System.out.println("Locked=" + lm.checkLocked());
                int i2 = 0;
                while (i2 < res.length) {
                    ResourceLock rl = new ResourceLock(res[i2]);
                    rl.readLock();
                    System.out.println("Resource=" + rl.getResourceName());
                    System.out.println("Application=" + rl.getApplication());
                    System.out.println("Description=" + rl.getDescription());
                    System.out.println("StartDate=" + rl.getStartDate());
                    System.out.println("Duration=" + rl.getDuration());
                    System.out.println("IP=" + rl.getIpAddress());
                    System.out.println("User=" + rl.getUser());
                    ++i2;
                }
            } else {
                System.err.println("Unknown command " + args[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ResourceLock[] listLocks() throws IOException {
        LinkedList<ResourceLock> lockList = new LinkedList<ResourceLock>();
        File lockDir = new File(LOCK_DIR);
        String[] files = lockDir.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                String resource = files[i];
                if (resource.endsWith(LOCK_EXT)) {
                    int end = resource.length() - LOCK_EXT.length();
                    ResourceLock lock = new ResourceLock(resource.substring(0, end));
                    lock.readLock();
                    lockList.add(lock);
                }
                ++i;
            }
        }
        ResourceLock[] locks = new ResourceLock[lockList.size()];
        lockList.toArray(locks);
        return locks;
    }

    static {
        FRU_SEPARATOR = FRU_SEPARATOR;
        LOCK_DIR = LOCK_DIR;
        MASTERLOCK = MASTERLOCK;
        LOCK_EXT = LOCK_EXT;
        pid = LockManager.setDefaultPID();
        sccs_id = sccs_id;
    }

    private class MasterLocker
    implements Runnable {
        private boolean timedOut;
        private long limit;

        private MasterLocker() {
        }

        public void run() {
            boolean locked = LockManager.this.lockMaster(true);
            LockManager.this.finishedOp();
            if (this.timedOut) {
                LockManager.this.unlockMaster();
            }
        }

        public void setTimedOut() {
            this.timedOut = true;
        }
    }
}

