/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.HTTPConnection;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static final String cvs_id = "$Id: XMLUtil.java,v 1.5 2004/10/15 17:32:46 jkremer Exp $";

    public static Node getNode(String document) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(new InputSource(new StringReader(document)));
            return xmlDoc.getDocumentElement();
        }
        catch (SAXParseException se) {
            HTTPConnection.logger.fine("Parse error at line " + se.getLineNumber() + ":" + se.getColumnNumber());
            return null;
        }
        catch (Exception e) {
            HTTPConnection.logger.log(Level.FINE, "XML Error", e);
            return null;
        }
    }

    public static Node getNode(Reader document) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(new InputSource(document));
            return xmlDoc.getDocumentElement();
        }
        catch (SAXParseException se) {
            HTTPConnection.logger.fine("Parse error at line " + se.getLineNumber() + ":" + se.getColumnNumber());
            return null;
        }
        catch (Exception e) {
            HTTPConnection.logger.log(Level.FINE, "XML Error", e);
            return null;
        }
    }

    public static String getCdata(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                if (cnode.getNodeType() == 3 || cnode.getNodeType() == 4) {
                    sb.append(cnode.getNodeValue());
                }
                ++j;
            }
        }
        return sb.toString();
    }

    public static int getInteger(Node node, int defaultValue) {
        try {
            return Integer.parseInt(XMLUtil.getCdata(node));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getAttribute(NamedNodeMap nnm, String name) {
        Node n = nnm.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    public static String getAttribute(Node node, String name) {
        return XMLUtil.getAttribute(node.getAttributes(), name);
    }

    public static void parseValue(Node node, Properties p) {
        if (node.getNodeType() == 1 && "VALUE".equals(node.getNodeName())) {
            NamedNodeMap map = node.getAttributes();
            String name = XMLUtil.getAttribute(map, "ID");
            String value = XMLUtil.getCdata(node);
            if (name != null && value != null) {
                p.setProperty(name, value);
            }
        }
    }

    public static void parseValues(Node node, Properties p) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                XMLUtil.parseValue(cnode, p);
                ++j;
            }
        }
    }

    public static void parseProperties(Node node, Properties p) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                if (cnode.getNodeType() == 1) {
                    String name = cnode.getNodeName();
                    String value = XMLUtil.getCdata(cnode);
                    if (value != null) {
                        p.setProperty(name, value);
                    }
                }
                ++j;
            }
        }
    }

    public static boolean isElement(Node node, String name) {
        if (node == null) {
            return false;
        }
        return node.getNodeType() == 1 && name.equals(node.getNodeName());
    }

    static {
        cvs_id = cvs_id;
    }
}

