/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AbstractService;
import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.event.EventSubscriptionService;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventSubscriptionImpl
extends AbstractService
implements EventSubscriptionService {
    public static final String _SOURCE_REVISION = "$Revision: 1.4 $";

    public EventSubscriptionImpl(URL agent, String user, String credential) {
        super(agent, user, credential);
    }

    public void register(URL url) throws StoradeException {
        this.register(url, "EventSubscriptionService", 0, true);
    }

    public void register(URL url, String description, int severity, boolean content) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Contract::add");
        cmd.fastcgi();
        cmd.setProperty("url", url.toString());
        cmd.setProperty("min_sev", Integer.toString(severity));
        cmd.setProperty("desc", description);
        cmd.setProperty("content", content ? "1" : "0");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "CONTRACT");
        if (error.isError()) {
            throw error.toException();
        }
        String contractResp = EventSubscriptionImpl.parseContract(resp.getData());
        if (!"ADDED".equals(contractResp)) {
            throw new StoradeException("sa.error", new Object[]{contractResp});
        }
    }

    public void unregister(URL url) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Contract::delete");
        cmd.fastcgi();
        cmd.setProperty("url", url.toString());
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "CONTRACT");
        if (error.isError()) {
            throw error.toException();
        }
    }

    public boolean exists(URL url) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Contract::exists");
        cmd.fastcgi();
        cmd.setProperty("url", url.toString());
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "CONTRACT");
        if (error.isError()) {
            throw error.toException();
        }
        return "YES".equals(EventSubscriptionImpl.parseContract(resp.getData()));
    }

    public URL[] list() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Contract::list");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "CONTRACTS");
        if (error.isError()) {
            throw error.toException();
        }
        List clist = EventSubscriptionImpl.parseContracts(resp.getData());
        Iterator iter = clist.iterator();
        URL[] contracts = new URL[clist.size()];
        int i = 0;
        while (i < contracts.length) {
            Properties p = (Properties)iter.next();
            String curl = p.getProperty("url");
            try {
                contracts[i] = new URL(curl);
            }
            catch (Exception e) {
                contracts[i] = null;
            }
            ++i;
        }
        return contracts;
    }

    private static String parseContract(String report) {
        Node node = XMLUtil.getNode(report);
        if (node.getNodeType() == 1 && "CONTRACT".equals(node.getNodeName())) {
            return XMLUtil.getCdata(node);
        }
        return null;
    }

    private static List parseContracts(String report) {
        NodeList children;
        LinkedList<Properties> list = new LinkedList<Properties>();
        Node node = XMLUtil.getNode(report);
        if (node.getNodeType() == 1 && "CONTRACTS".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() == 1) {
                    Properties p = new Properties();
                    XMLUtil.parseProperties(cnode, p);
                    list.add(p);
                }
                ++i;
            }
        }
        return list;
    }

    static /* synthetic */ String access$000(String x0) {
        return EventSubscriptionImpl.parseContract(x0);
    }

    static /* synthetic */ List access$100(String x0) {
        return EventSubscriptionImpl.parseContracts(x0);
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }
}

