/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.storade.service.device.DiscoveryResult;
import java.util.LinkedList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoveryResultXML
extends DiscoveryResult {
    public static final String cvs_id = "$Id: DiscoveryResultXML.java,v 1.2 2004/10/13 18:09:45 jkremer Exp $";

    DiscoveryResultXML(String doc) {
        this.parseNode(XMLUtil.getNode(doc));
    }

    DiscoveryResultXML(Node node) {
        this.parseNode(node);
    }

    static DiscoveryResult[] parseDiscoveries(String doc) {
        NodeList children;
        LinkedList<DiscoveryResultXML> list = new LinkedList<DiscoveryResultXML>();
        Node node = XMLUtil.getNode(doc);
        if (node.getNodeType() == 1 && "DISCOVERIES".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                DiscoveryResultXML disco = new DiscoveryResultXML(cnode);
                list.add(disco);
                ++j;
            }
        }
        DiscoveryResult[] dr = new DiscoveryResult[list.size()];
        list.toArray(dr);
        return dr;
    }

    private void parseNode(Node dnode) {
        if (!XMLUtil.isElement(dnode, "DISCOVERY")) {
            return;
        }
        NodeList clist = dnode.getChildNodes();
        int i = 0;
        while (i < clist.getLength()) {
            Node node = clist.item(i);
            if (node.getNodeType() == 1) {
                if ("DISCOVERY_MODE".equals(node.getNodeName())) {
                    String dmode = XMLUtil.getCdata(node);
                    this.setMode(dmode);
                    this.setExecutionId(dmode);
                } else if ("AGENTS_RUNNING".equals(node.getNodeName())) {
                    int running = -1;
                    try {
                        Integer.parseInt(XMLUtil.getCdata(node));
                    }
                    catch (Exception e) {
                        this.setState(0);
                    }
                    if (running == 0) {
                        this.setState(2);
                    } else {
                        this.setState(1);
                    }
                } else if (!"AGENTS_STOP".equals(node.getNodeName()) && !"AGENTS_PROCESSED".equals(node.getNodeName()) && !"DEVICES_FOUND".equals(node.getNodeName()) && "DEVICES".equals(node.getNodeName())) {
                    LinkedList<DeviceProperties> dlist = new LinkedList<DeviceProperties>();
                    NodeList children = node.getChildNodes();
                    if (children != null) {
                        int j = 0;
                        while (j < children.getLength()) {
                            dlist.add(DiscoveryResultXML.parseDeviceNode(children.item(j)));
                            ++j;
                        }
                    }
                    DeviceProperties[] devs = new DeviceProperties[dlist.size()];
                    dlist.toArray(devs);
                    this.setDiscoveredDevices(devs);
                }
            }
            ++i;
        }
    }

    private static DeviceProperties parseDeviceNode(Node node) {
        if (!XMLUtil.isElement(node, "DEVICE")) {
            return null;
        }
        DeviceProperties dp = new DeviceProperties();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int j = 0;
            while (j < children.getLength()) {
                DiscoveryResultXML.parseDeviceProps(children.item(j), dp);
                ++j;
            }
        }
        return dp;
    }

    private static void parseDeviceProps(Node node, DeviceProperties dp) {
        if (node.getNodeType() == 1) {
            if ("ALTIP".equals(node.getNodeName())) {
                dp.setAlternateIP(XMLUtil.getCdata(node));
            } else if ("ALTIPNO".equals(node.getNodeName())) {
                dp.setAlternateIPNumber(XMLUtil.getCdata(node));
            } else if ("CLASS".equals(node.getNodeName())) {
                dp.setClass(XMLUtil.getCdata(node));
            } else if ("IP".equals(node.getNodeName())) {
                dp.setIP(XMLUtil.getCdata(node));
            } else if ("IPNO".equals(node.getNodeName())) {
                dp.setIPNumber(XMLUtil.getCdata(node));
            } else if ("Key".equals(node.getNodeName())) {
                dp.setKey(XMLUtil.getCdata(node));
            } else if ("NAME".equals(node.getNodeName())) {
                dp.setName(XMLUtil.getCdata(node));
            } else if ("PROXYS".equals(node.getNodeName())) {
                dp.setProperty("proxys", XMLUtil.getCdata(node));
            } else if ("TYPE".equals(node.getNodeName())) {
                dp.setType(XMLUtil.getCdata(node));
            } else if ("WWN".equals(node.getNodeName())) {
                dp.setWWN(XMLUtil.getCdata(node));
            }
        }
    }

    static {
        cvs_id = cvs_id;
    }
}

