/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AbstractService;
import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.storade.service.device.DiscoveryResult;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceMaintenanceImpl
extends AbstractService
implements DeviceMaintenanceService {
    public static final String cvs_id = "$Id: DeviceMaintenanceImpl.java,v 1.13 2004/10/15 17:32:46 jkremer Exp $";

    public DeviceMaintenanceImpl(URL agent, String user, String credential) {
        super(agent, user, credential);
    }

    public synchronized DeviceProperties[] getDeviceList() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Control::GetDevices");
        cmd.fastcgi();
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        return DeviceMaintenanceImpl.getInstancesXML(resp.getData());
    }

    public synchronized DeviceProperties[] getDeviceList(String type) throws StoradeException {
        DeviceProperties[] alldevs = this.getDeviceList();
        if (type == null) {
            return alldevs;
        }
        LinkedList<DeviceProperties> list = new LinkedList<DeviceProperties>();
        int i = 0;
        while (i < alldevs.length) {
            if (type.equals(alldevs[i].getType())) {
                list.add(alldevs[i]);
            }
            ++i;
        }
        DeviceProperties[] dp = new DeviceProperties[list.size()];
        list.toArray(dp);
        return dp;
    }

    public synchronized DeviceProperties[] getDeviceList(DeviceProperties props) throws StoradeException {
        DeviceProperties[] alldevs = this.getDeviceList();
        if (props == null) {
            return alldevs;
        }
        LinkedList<DeviceProperties> list = new LinkedList<DeviceProperties>();
        Properties filterProps = props.getProperties();
        Set<Map.Entry<Object, Object>> filterSet = filterProps.entrySet();
        int i = 0;
        while (i < alldevs.length) {
            boolean doAdd = true;
            Iterator<Map.Entry<Object, Object>> filterIter = filterSet.iterator();
            while (filterIter.hasNext()) {
                Map.Entry<Object, Object> entry = filterIter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String prop = alldevs[i].getProperty(key);
                if (value == null || prop == null || value.equals(prop)) continue;
                doAdd = false;
                break;
            }
            if (doAdd) {
                list.add(alldevs[i]);
            }
            ++i;
        }
        DeviceProperties[] dp = new DeviceProperties[list.size()];
        list.toArray(dp);
        return dp;
    }

    public synchronized DeviceProperties getDeviceProperties(String deviceKey) throws StoradeException {
        DeviceProperties[] alldevs = this.getDeviceList();
        int i = 0;
        while (i < alldevs.length) {
            if (deviceKey.equals(alldevs[i].getKey())) {
                return alldevs[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized void updateDeviceProperties(DeviceProperties props) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Device::Modify");
        cmd.fastcgi();
        if (props == null) {
            throw new IllegalArgumentException();
        }
        cmd.addProperties(props.getProperties());
        cmd.setProperty("_CMD", "merge");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
    }

    public void deletePropery(String deviceKey, String name, String value) throws StoradeException {
        HTTPResponse resp;
        AgentError error;
        AgentCommand cmd = new AgentCommand("Client::Device::DeleteProperty");
        cmd.fastcgi();
        if (name != null) {
            cmd.setProperty("name", name);
        }
        if (value != null) {
            cmd.setProperty("value", value);
        }
        if ((error = new AgentError(resp = this.getConnection().getResponse(cmd))).isError()) {
            throw error.toException();
        }
    }

    public synchronized void removeDevice(String deviceKey) throws StoradeException {
        DeviceProperties props = this.getDeviceProperties(deviceKey);
        if (props == null) {
            throw new StoradeException("id.does.not.exist");
        }
        AgentCommand cmd = new AgentCommand("Client::Device::Remove");
        cmd.fastcgi();
        cmd.setProperty("key", props.getType() + ":" + deviceKey);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        if (resp.getResponseCode() != 200) {
            throw new StoradeException("communication.error");
        }
        String data = resp.getData().trim();
        if (!"OK".equals(data)) {
            throw new StoradeException("sa.error", new Object[]{data});
        }
    }

    public synchronized DeviceProperties[] discoverDevice(String ipAddress) throws StoradeException {
        HTTPResponse resp;
        AgentError error;
        AgentCommand cmd = new AgentCommand("Client::Device::DiscoverIp");
        cmd.setProperty("ip", ipAddress);
        if (AbstractService.logger.isLoggable(Level.FINE)) {
            AbstractService.logger.fine("discoverDevice cmd=" + cmd.getCommandData());
        }
        if ((error = new AgentError(resp = this.getConnection().getResponse(cmd))).isError()) {
            throw error.toException();
        }
        if (AbstractService.logger.isLoggable(Level.FINE)) {
            AbstractService.logger.fine(resp.getData());
        }
        return DeviceMaintenanceImpl.parseMultiDevDoc(XMLUtil.getNode(resp.getData()), "DISCOVER", "DEVICE");
    }

    public synchronized String discoverDevice(String ipList, boolean add, boolean monitor, String prefix, String agentHost) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Discovery::discovery");
        cmd.setProperty("method", "Subnet");
        if (ipList == null) {
            throw new IllegalArgumentException();
        }
        cmd.setProperty("ip_list", ipList);
        if (agentHost != null) {
            cmd.setProperty("select_host", agentHost);
        }
        if (prefix != null) {
            cmd.setProperty("prefix", prefix);
        }
        cmd.setProperty("monitor", monitor ? "Y" : "N");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        return "subnet";
    }

    private static DeviceProperties[] parseMultiDevDoc(Node node, String rname, String dname) {
        NodeList children;
        LinkedList<DeviceProperties> list = new LinkedList<DeviceProperties>();
        if (XMLUtil.isElement(node, rname) && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node cnode = children.item(i);
                DeviceProperties dp = DeviceMaintenanceImpl.parseDevPropsNode(cnode, dname);
                if (dp != null) {
                    list.add(dp);
                }
                ++i;
            }
        }
        return list.toArray(new DeviceProperties[list.size()]);
    }

    private static DeviceProperties parseDevPropsDoc(String report, String nname) {
        return DeviceMaintenanceImpl.parseDevPropsNode(XMLUtil.getNode(report), nname);
    }

    private static DeviceProperties parseDevPropsNode(Node node, String nname) {
        NodeList children;
        if (node.getNodeType() == 1 && nname.equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            Properties p = new Properties();
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                XMLUtil.parseValue(cnode, p);
                ++j;
            }
            return new DeviceProperties(p);
        }
        return null;
    }

    private static DiscoveryResult[] getDiscoveryResults(String doc) {
        NodeList children;
        Node node = XMLUtil.getNode(doc);
        LinkedList<DiscoveryResult> list = new LinkedList<DiscoveryResult>();
        if (node != null && node.getNodeType() == 1 && "DISCOVERIES".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                DiscoveryResult dr = DeviceMaintenanceImpl.getDiscoveryResult(cnode);
                if (dr != null) {
                    list.add(dr);
                }
                ++j;
            }
        }
        DiscoveryResult[] result = new DiscoveryResult[list.size()];
        list.toArray(result);
        return result;
    }

    private static DiscoveryResult getDiscoveryResult(Node node) {
        DiscoveryResult result = null;
        if (node.getNodeType() == 1 && "DISCOVERY".equals(node.getNodeName())) {
            result = new DiscoveryResult();
            LinkedList<DeviceProperties> devs = new LinkedList<DeviceProperties>();
            NodeList children = node.getChildNodes();
            int running = 0;
            int stop = 0;
            int found = 0;
            int processed = 0;
            Properties map = DeviceMaintenanceImpl.getDiscoMap();
            if (children != null) {
                int i = 0;
                while (i < children.getLength()) {
                    Node cnode = children.item(i);
                    if (cnode.getNodeType() == 1) {
                        NodeList dchildren;
                        if ("DISCOVERY_MODE".equals(cnode.getNodeName())) {
                            result.setMode(XMLUtil.getCdata(cnode));
                            result.setExecutionId(XMLUtil.getCdata(cnode));
                        }
                        if ("AGENTS_RUNNING".equals(cnode.getNodeName())) {
                            running = XMLUtil.getInteger(cnode, running);
                        }
                        if ("AGENTS_STOP".equals(cnode.getNodeName())) {
                            stop = XMLUtil.getInteger(cnode, stop);
                        }
                        if ("AGENTS_PROCESSED".equals(cnode.getNodeName())) {
                            processed = XMLUtil.getInteger(cnode, processed);
                        }
                        if ("DEVICES_FOUND".equals(cnode.getNodeName())) {
                            found = XMLUtil.getInteger(cnode, found);
                        } else if ("DEVICES".equals(cnode.getNodeName()) && (dchildren = cnode.getChildNodes()) != null) {
                            int j = 0;
                            while (j < dchildren.getLength()) {
                                Node dnode = dchildren.item(j);
                                DeviceProperties dp = DeviceMaintenanceImpl.getDiscoDevProps(dnode, map);
                                if (dp != null) {
                                    devs.add(dp);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            DeviceProperties[] dprops = new DeviceProperties[devs.size()];
            devs.toArray(dprops);
            result.setDiscoveredDevices(dprops);
            if (running > 0) {
                result.setState(1);
            } else {
                result.setState(2);
            }
        }
        return result;
    }

    private static Properties getDiscoMap() {
        Properties map = new Properties();
        map.setProperty("CLASS", "class");
        map.setProperty("HOST", "host");
        map.setProperty("IP", "ip");
        map.setProperty("IPNO", "agent");
        map.setProperty("KEY", "key");
        map.setProperty("MONITOR_ON", "active");
        map.setProperty("NAME", "name");
        map.setProperty("TYPE", "type");
        map.setProperty("USERLABEL", "userLabel");
        map.setProperty("WWN", "wwn");
        map.setProperty("WWN2", "wwn2");
        return map;
    }

    private static DeviceProperties getDiscoDevProps(Node node, Properties map) {
        NodeList children;
        if (node.getNodeType() == 1 && "DEVICE".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            Properties p = new Properties();
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                String name = cnode.getNodeName();
                String mname = map.getProperty(name);
                if (mname == null) {
                    mname = name;
                }
                String value = XMLUtil.getCdata(cnode);
                p.setProperty(mname, value);
                ++j;
            }
            return new DeviceProperties(p);
        }
        return null;
    }

    private static DeviceProperties[] getInstancesXML(String report) {
        LinkedList list = new LinkedList();
        Node docNode = XMLUtil.getNode(report);
        if (docNode != null) {
            DeviceMaintenanceImpl.parseNode(docNode, list);
        }
        DeviceProperties[] sas = new DeviceProperties[list.size()];
        list.toArray(sas);
        return sas;
    }

    private static void parseNode(Node node, LinkedList list) {
        if (node.getNodeType() == 1) {
            NodeList children;
            if ("DEVICE".equals(node.getNodeName())) {
                NodeList children2 = node.getChildNodes();
                if (children2 != null) {
                    Properties p = new Properties();
                    int j = 0;
                    while (j < children2.getLength()) {
                        Node cnode = children2.item(j);
                        XMLUtil.parseValue(cnode, p);
                        ++j;
                    }
                    list.add(new DeviceProperties(p));
                }
            } else if ("DEVICES".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
                int j = 0;
                while (j < children.getLength()) {
                    Node cnode = children.item(j);
                    DeviceMaintenanceImpl.parseNode(cnode, list);
                    ++j;
                }
            }
        }
    }

    public synchronized DeviceProperties addDevice(DeviceProperties props) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Device::Insert");
        cmd.addProperties(props.getProperties());
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "DEVICE_INSERT");
        if (error.isError()) {
            throw error.toException();
        }
        return DeviceMaintenanceImpl.parseDevPropsDoc(resp.getData(), "DEVICE_INSERT");
    }

    public synchronized DiscoveryResult getDiscoveryResult(String id) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Discovery::displayList");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        DiscoveryResult[] results = DeviceMaintenanceImpl.getDiscoveryResults(resp.getData());
        int i = 0;
        while (i < results.length) {
            if (id.equals(results[i].getExecutionId())) {
                return results[i];
            }
            ++i;
        }
        return new DiscoveryResult();
    }

    static /* synthetic */ DiscoveryResult[] access$000(String x0) {
        return DeviceMaintenanceImpl.getDiscoveryResults(x0);
    }

    static {
        cvs_id = cvs_id;
    }
}

