/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSeverity;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSummary;
import java.util.LinkedList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlarmSummaryXML
extends AlarmSummary {
    public static final String cvs_id = "$Id: AlarmSummaryXML.java,v 1.3 2005/03/24 16:12:13 jkremer Exp $";

    static AlarmSummary[] parseXML(String doc) {
        LinkedList list = AlarmSummaryXML.parseNode(XMLUtil.getNode(doc));
        AlarmSummary[] alarms = new AlarmSummary[list.size()];
        list.toArray(alarms);
        return alarms;
    }

    private static LinkedList parseNode(Node node) {
        NodeList children;
        LinkedList list = new LinkedList();
        if (node.getNodeType() == 1 && "ALARMS".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                AlarmSummaryXML.parseNode(cnode, list);
                ++j;
            }
        }
        return list;
    }

    private static void parseNode(Node node, LinkedList list) {
        if (node.getNodeType() == 1 && "event".equals(node.getNodeName())) {
            AlarmSummaryXML alarm = new AlarmSummaryXML();
            NodeList children = node.getChildNodes();
            if (children != null) {
                int j = 0;
                while (j < children.getLength()) {
                    Node cnode = children.item(j);
                    AlarmSummaryXML.parseNode(cnode, alarm);
                    ++j;
                }
            }
            list.add(alarm);
        }
    }

    private static void parseNode(Node node, AlarmSummaryXML a) {
        if (node.getNodeType() == 1) {
            if ("type".equals(node.getNodeName())) {
                a.type = XMLUtil.getCdata(node);
            } else if ("key".equals(node.getNodeName())) {
                a.key = XMLUtil.getCdata(node);
            } else if ("topic".equals(node.getNodeName())) {
                a.element = XMLUtil.getCdata(node);
            } else if ("severity".equals(node.getNodeName())) {
                int severity = Integer.parseInt(XMLUtil.getCdata(node).trim());
                a.severity = AlarmSeverity.mapStoradeSeverity(severity);
            } else if ("ack".equals(node.getNodeName())) {
                a.state = "Y".equals(XMLUtil.getCdata(node)) ? 1 : 0;
            } else if ("desc".equals(node.getNodeName())) {
                String desc = XMLUtil.getCdata(node);
                if (desc != null && desc.length() > 18) {
                    a.date = desc.substring(0, 18);
                }
            } else if (!("parent".equals(node.getNodeName()) || "parent_id".equals(node.getNodeName()) || "eventType".equals(node.getNodeName()))) {
                if ("deviceName".equals(node.getNodeName())) {
                    a.name = XMLUtil.getCdata(node);
                } else if ("gridCode".equals(node.getNodeName())) {
                    a.gridCode = XMLUtil.getCdata(node);
                } else if ("ip".equals(node.getNodeName())) {
                    a.ip = XMLUtil.getCdata(node);
                }
            }
        }
    }

    static {
        cvs_id = cvs_id;
    }
}

