/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AbstractService;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.DiscoveryCommand;
import com.sun.netstorage.fm.storade.client.http.HTTPConnection;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.agent.AgentConfigService;
import com.sun.netstorage.fm.storade.service.agent.AgentSummary;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AgentConfigImpl
extends AbstractService
implements AgentConfigService {
    public static final String cvs_id = "$Id: AgentConfigImpl.java,v 1.7 2004/10/13 18:09:44 jkremer Exp $";

    public AgentConfigImpl(URL agent, String user, String credential) {
        super(agent, user, credential);
    }

    public AgentSummary getLocalAgent() throws StoradeException {
        AgentSummary[] as = this.getAgentList();
        if (as == null) {
            return null;
        }
        InetAddress local = null;
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        int i = 0;
        while (i < as.length) {
            if (local.equals(as[i].getInetAddress())) {
                return as[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized AgentSummary[] getAgentList() throws StoradeException {
        HTTPConnection http = this.getConnection();
        DiscoveryCommand cmd = new DiscoveryCommand();
        cmd.fastcgi();
        cmd.setFormat("xml");
        HTTPResponse resp = http.getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        return AgentConfigImpl.getSummaryInstancesXML(resp.getData());
    }

    private static AgentSummary[] getSummaryInstancesXML(String report) {
        LinkedList list = new LinkedList();
        Node docNode = XMLUtil.getNode(report);
        if (docNode != null) {
            AgentConfigImpl.parseNode(docNode, list);
        }
        AgentSummary[] sas = new AgentSummary[list.size()];
        list.toArray(sas);
        return sas;
    }

    private static void parseNode(Node node, LinkedList list) {
        if (node.getNodeType() == 1) {
            NodeList children;
            if ("AGENT".equals(node.getNodeName())) {
                NodeList children2 = node.getChildNodes();
                if (children2 != null) {
                    Properties p = new Properties();
                    int j = 0;
                    while (j < children2.getLength()) {
                        Node cnode = children2.item(j);
                        XMLUtil.parseValue(cnode, p);
                        ++j;
                    }
                    list.add(new AgentSummary(p));
                }
            } else if ("DISCOVERY_REPORT".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
                int j = 0;
                while (j < children.getLength()) {
                    Node cnode = children.item(j);
                    AgentConfigImpl.parseNode(cnode, list);
                    ++j;
                }
            }
        }
    }

    static {
        cvs_id = cvs_id;
    }
}

