/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.impl.common.IOUtil;
import org.apache.xmlbeans.impl.common.XmlErrorWatcher;
import org.apache.xmlbeans.impl.schema.SchemaTypeCodePrinter;
import repackage.Repackager;

public class SchemaCodeGenerator {
    private static Set deleteFileQueue;
    private static int triesRemaining;
    static /* synthetic */ Class class$org$apache$xmlbeans$SchemaTypeSystem;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$xmlbeans$impl$common$XmlErrorWatcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean compileTypeSystem(SchemaTypeSystem saver, File sourcedir, File[] javasrc, Map sourcesToCopyMap, File[] classpath, File classesdir, File outputJar, boolean nojavac, boolean jaxb, XmlErrorWatcher errors, String repackage, boolean verbose, List sourcefiles) {
        if (sourcedir == null || classesdir == null) {
            throw new IllegalArgumentException("Source and class gen dir must not be null.");
        }
        boolean failure = false;
        saver.saveToDirectory(classesdir);
        if (sourcesToCopyMap != null && sourcesToCopyMap.size() > 0) {
            File schemasdir = SchemaCodeGenerator.createDir(classesdir, "schema/src");
            Iterator iter = sourcesToCopyMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    URL url = new URL(key);
                    String schemalocation = (String)sourcesToCopyMap.get(key);
                    File targetFile = new File(schemasdir, schemalocation);
                    File parentDir = new File(targetFile.getParent());
                    SchemaCodeGenerator.createDir(parentDir, null);
                    InputStream in = url.openStream();
                    FileOutputStream out = new FileOutputStream(new File(schemasdir, schemalocation));
                    IOUtil.copyCompletely(in, out);
                }
                catch (IOException e) {
                    System.err.println("IO Error " + e);
                }
            }
        }
        Repackager repackager = repackage == null ? null : new Repackager(repackage);
        try {
            String filename = SchemaTypeCodePrinter.indexClassForSystem(saver).replace('.', File.separatorChar) + ".java";
            File sourcefile = new File(sourcedir, filename);
            sourcefile.getParentFile().mkdirs();
            Writer writer = repackager == null ? new FileWriter(sourcefile) : new RepackagingWriter(sourcefile, repackager);
            SchemaTypeCodePrinter.printLoader(writer, saver);
            writer.close();
            sourcefiles.add(sourcefile);
        }
        catch (IOException e) {
            System.err.println("IO Error " + e);
            failure = true;
        }
        failure = !jaxb ? (failure &= SchemaCodeGenerator.genTypes(saver, sourcefiles, sourcedir, repackager, verbose)) : (failure &= SchemaCodeGenerator.jaxbCodeGenerator(saver, sourcefiles, sourcedir, classesdir, errors));
        return !failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean genTypes(SchemaTypeSystem saver, List sourcefiles, File sourcedir, Repackager repackager, boolean verbose) {
        boolean failure = false;
        ArrayList<SchemaType> types = new ArrayList<SchemaType>();
        types.addAll(Arrays.asList(saver.globalTypes()));
        types.addAll(Arrays.asList(saver.documentTypes()));
        types.addAll(Arrays.asList(saver.attributeTypes()));
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Writer writer;
            String filename;
            SchemaType type;
            block25: {
                type = (SchemaType)i.next();
                if (verbose) {
                    System.err.println("Compiling type " + type);
                }
                if (type.isBuiltinType() || type.getFullJavaName() == null) continue;
                String fjn = type.getFullJavaName();
                if (fjn.indexOf(36) > 0) {
                    fjn = fjn.substring(0, fjn.lastIndexOf(46)) + "." + fjn.substring(fjn.indexOf(36) + 1);
                }
                filename = fjn.replace('.', File.separatorChar) + ".java";
                writer = null;
                File sourcefile = new File(sourcedir, filename);
                sourcefile.getParentFile().mkdirs();
                if (verbose) {
                    System.err.println("created " + sourcefile.getAbsolutePath());
                }
                writer = repackager == null ? new FileWriter(sourcefile) : new RepackagingWriter(sourcefile, repackager);
                SchemaTypeCodePrinter.printType(writer, type);
                writer.close();
                sourcefiles.add(sourcefile);
                Object var14_15 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block25;
                }
                catch (IOException e2) {}
                break block25;
                {
                    catch (IOException e) {
                        System.err.println("IO Error " + e);
                        failure = true;
                        var14_15 = null;
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            break block25;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            filename = type.getFullJavaImplName().replace('.', File.separatorChar) + ".java";
            File implFile = new File(sourcedir, filename);
            if (verbose) {
                System.err.println("created " + implFile.getAbsolutePath());
            }
            implFile.getParentFile().mkdirs();
            writer = repackager == null ? new FileWriter(implFile) : new RepackagingWriter(implFile, repackager);
            SchemaTypeCodePrinter.printTypeImpl(writer, type);
            writer.close();
            sourcefiles.add(implFile);
            Object var17_17 = null;
            try {
                if (writer == null) continue;
                writer.close();
            }
            catch (IOException e3) {}
            continue;
            {
                catch (IOException e) {
                    System.err.println("IO Error " + e);
                    failure = true;
                    var17_17 = null;
                    try {
                        if (writer == null) continue;
                        writer.close();
                    }
                    catch (IOException e3) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var17_17 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return failure;
    }

    private static boolean jaxbCodeGenerator(SchemaTypeSystem saver, List sourcefiles, File sourcedir, File classesdir, XmlErrorWatcher errors) {
        try {
            return (Boolean)JaxbCodeGeneratorHolder._jaxbCodeGeneratorMethod.invoke(null, saver, sourcefiles, sourcedir, classesdir, errors);
        }
        catch (InvocationTargetException e) {
            IllegalStateException e2 = new IllegalStateException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalAccessException e) {
            IllegalStateException e2 = new IllegalStateException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    protected static File createDir(File rootdir, String subdir) {
        boolean created;
        File newdir = subdir == null ? rootdir : new File(rootdir, subdir);
        boolean bl = created = newdir.exists() && newdir.isDirectory() || newdir.mkdirs();
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)("Could not create " + newdir.getAbsolutePath()));
        }
        return newdir;
    }

    protected static File createTempDir() throws IOException {
        File tmpFile = File.createTempFile("xbean", null);
        String path = tmpFile.getAbsolutePath();
        if (!path.endsWith(".tmp")) {
            throw new IOException("Error: createTempFile did not create a file ending with .tmp");
        }
        path = path.substring(0, path.length() - 4);
        File tmpSrcDir = null;
        for (int count = 0; count < 100; ++count) {
            String name = path + ".d" + (count == 0 ? "" : Integer.toString(count++));
            tmpSrcDir = new File(name);
            if (tmpSrcDir.exists()) continue;
            boolean created = tmpSrcDir.mkdirs();
            if (!$assertionsDisabled && !created) {
                throw new AssertionError((Object)("Could not create " + tmpSrcDir.getAbsolutePath()));
            }
            break;
        }
        tmpFile.deleteOnExit();
        return tmpSrcDir;
    }

    protected static void tryHardToDelete(File dir) {
        SchemaCodeGenerator.tryToDelete(dir);
        if (dir.exists()) {
            SchemaCodeGenerator.tryToDeleteLater(dir);
        }
    }

    private static void tryToDelete(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                String[] list = dir.list();
                for (int i = 0; i < list.length; ++i) {
                    SchemaCodeGenerator.tryToDelete(new File(dir, list[i]));
                }
            }
            if (!dir.delete()) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryNowThatItsLater() {
        ArrayList files;
        Set set = deleteFileQueue;
        synchronized (set) {
            files = new ArrayList(deleteFileQueue);
            deleteFileQueue.clear();
        }
        ArrayList<File> retry = new ArrayList<File>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            SchemaCodeGenerator.tryToDelete(file);
            if (!file.exists()) continue;
            retry.add(file);
        }
        Set set2 = deleteFileQueue;
        synchronized (set2) {
            if (triesRemaining > 0) {
                --triesRemaining;
            }
            if (triesRemaining <= 0 || retry.size() == 0) {
                triesRemaining = 0;
            } else {
                deleteFileQueue.addAll(retry);
            }
            return triesRemaining <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void giveUp() {
        Set set = deleteFileQueue;
        synchronized (set) {
            deleteFileQueue.clear();
            triesRemaining = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryToDeleteLater(File dir) {
        Set set = deleteFileQueue;
        synchronized (set) {
            deleteFileQueue.add(dir);
            if (triesRemaining == 0) {
                new Thread(){

                    public void run() {
                        try {
                            while (true) {
                                if (SchemaCodeGenerator.tryNowThatItsLater()) {
                                    return;
                                }
                                Thread.sleep(3000L);
                            }
                        }
                        catch (InterruptedException e) {
                            SchemaCodeGenerator.giveUp();
                            return;
                        }
                    }
                };
            }
            if (triesRemaining < 10) {
                triesRemaining = 10;
            }
        }
    }

    static {
        $assertionsDisabled = !SchemaCodeGenerator.class.desiredAssertionStatus();
        deleteFileQueue = new HashSet();
        triesRemaining = 0;
    }

    static class RepackagingWriter
    extends StringWriter {
        private File _file;
        private Repackager _repackager;

        public RepackagingWriter(File file, Repackager repackager) {
            this._file = file;
            this._repackager = repackager;
        }

        public void close() throws IOException {
            super.close();
            StringBuffer sb = this.getBuffer();
            this._repackager.repackage(sb);
            FileWriter fw = new FileWriter(this._file);
            fw.write(sb.toString());
            fw.close();
        }
    }

    private static class JaxbCodeGeneratorHolder {
        private static final Method _jaxbCodeGeneratorMethod = JaxbCodeGeneratorHolder.buildJaxbCodeGeneratorMethod();

        private JaxbCodeGeneratorHolder() {
        }

        private static Method buildJaxbCodeGeneratorMethod() {
            try {
                return Class.forName("org.apache.xmlbeans.impl.jaxb.compiler.JaxbCodeGenerator", false, (class$org$apache$xmlbeans$impl$tool$SchemaCodeGenerator == null ? (class$org$apache$xmlbeans$impl$tool$SchemaCodeGenerator = SchemaCodeGenerator.class$("org.apache.xmlbeans.impl.tool.SchemaCodeGenerator")) : class$org$apache$xmlbeans$impl$tool$SchemaCodeGenerator).getClassLoader()).getMethod("compile", class$org$apache$xmlbeans$SchemaTypeSystem == null ? (class$org$apache$xmlbeans$SchemaTypeSystem = SchemaCodeGenerator.class$("org.apache.xmlbeans.SchemaTypeSystem")) : class$org$apache$xmlbeans$SchemaTypeSystem, class$java$util$List == null ? (class$java$util$List = SchemaCodeGenerator.class$("java.util.List")) : class$java$util$List, class$java$io$File == null ? (class$java$io$File = SchemaCodeGenerator.class$("java.io.File")) : class$java$io$File, class$java$io$File == null ? (class$java$io$File = SchemaCodeGenerator.class$("java.io.File")) : class$java$io$File, class$org$apache$xmlbeans$impl$common$XmlErrorWatcher == null ? (class$org$apache$xmlbeans$impl$common$XmlErrorWatcher = SchemaCodeGenerator.class$("org.apache.xmlbeans.impl.common.XmlErrorWatcher")) : class$org$apache$xmlbeans$impl$common$XmlErrorWatcher);
            }
            catch (Exception e) {
                IllegalStateException e2 = new IllegalStateException("Cannot load JaxbCodeGenerator: verify that xbean.jar is on the classpath");
                e2.initCause(e);
                throw e2;
            }
        }
    }
}

