/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import com.bea.x2002.x09.xbean.config.ConfigDocument;
import com.bea.x2002.x09.xbean.config.Nsconfig;
import com.bea.x2002.x09.xbean.config.Qnameconfig;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class SchemaConfig {
    private Map _packageMap;
    private Map _prefixMap;
    private Map _suffixMap;
    private Map _qnameMap;

    private SchemaConfig() {
        this._packageMap = Collections.EMPTY_MAP;
        this._prefixMap = Collections.EMPTY_MAP;
        this._suffixMap = Collections.EMPTY_MAP;
        this._qnameMap = Collections.EMPTY_MAP;
    }

    public static SchemaConfig forConfigDocuments(ConfigDocument.Config[] configs) {
        return new SchemaConfig(configs);
    }

    private SchemaConfig(ConfigDocument.Config[] configs) {
        this._packageMap = new LinkedHashMap();
        this._prefixMap = new LinkedHashMap();
        this._suffixMap = new LinkedHashMap();
        this._qnameMap = new LinkedHashMap();
        for (int i = 0; i < configs.length; ++i) {
            ConfigDocument.Config config = configs[i];
            Nsconfig[] nsa = config.getNamespaceArray();
            for (int j = 0; j < nsa.length; ++j) {
                SchemaConfig.recordNamespaceSetting(nsa[j].getUri(), nsa[j].getPackage(), this._packageMap);
                SchemaConfig.recordNamespaceSetting(nsa[j].getUri(), nsa[j].getPrefix(), this._prefixMap);
                SchemaConfig.recordNamespaceSetting(nsa[j].getUri(), nsa[j].getSuffix(), this._suffixMap);
            }
            Qnameconfig[] qnc = config.getQnameArray();
            for (int j = 0; j < qnc.length; ++j) {
                this._qnameMap.put(qnc[j].getName(), qnc[j].getJavaname());
            }
        }
    }

    private static void recordNamespaceSetting(Object key, String value, Map result) {
        if (value == null) {
            return;
        }
        if (key == null) {
            result.put("", value);
        } else if (key instanceof String && "##any".equals(key)) {
            result.put(key, value);
        } else if (key instanceof List) {
            Iterator i = ((List)key).iterator();
            while (i.hasNext()) {
                String uri = (String)i.next();
                if ("##local".equals(uri)) {
                    uri = "";
                }
                result.put(uri, value);
            }
        }
    }

    private String lookup(Map map, String uri) {
        String result;
        if (uri == null) {
            uri = "";
        }
        if ((result = (String)map.get(uri)) != null) {
            return result;
        }
        return (String)map.get("##any");
    }

    public String lookupPackageForNamespace(String uri) {
        return this.lookup(this._packageMap, uri);
    }

    public String lookupPrefixForNamespace(String uri) {
        return this.lookup(this._prefixMap, uri);
    }

    public String lookupSuffixForNamespace(String uri) {
        return this.lookup(this._suffixMap, uri);
    }

    public String lookupJavanameForQName(QName qname) {
        return (String)this._qnameMap.get(qname);
    }
}

